package com.jumipm.workflow.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jumipm.workflow.FlowEngine;
import com.jumipm.workflow.HttpDisposeUtil;
import com.jumipm.workflow.ProcessEngine;
/**
 * 
 * @author leasonlive
 *
 */
@Service("flowEngine")
public class FlowEngineImpl implements FlowEngine {
	private static Log log = LogFactory.getLog(ProcessEngine.class);

	private volatile HttpDisposeUtil disposeUtil;
    private HttpDisposeUtil getDisposeUtil() {
        if (disposeUtil == null) {
            synchronized (this) {
                if (disposeUtil == null) {
                    disposeUtil = new HttpDisposeUtil(getEngineServiceUrl());
                }
            }
        }
        return disposeUtil;
    }
    
    /**
     * 获取引擎访问URL
     */
    public String getEngineServiceUrl() {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("application.properties");
        Properties prop = new Properties();
        String engineServiceUrl = "";
        try {
            prop.load(inStream);
            engineServiceUrl = prop.getProperty("flow.engineUrl").concat("/service");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return engineServiceUrl;
    }
    

    /**
     * 获取流程explorer访问URL
     */
    public String getExplorerServiceUrl() {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("application.properties");
        Properties prop = new Properties();
        String engineServiceUrl = "";
        try {
            prop.load(inStream);
            engineServiceUrl = prop.getProperty("explorer.engineUrl");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return engineServiceUrl;
    }
	
	
	public String getDeployments() throws Exception{
       String serviceBase = "/repository/process-definitions?latest=true&start=0&size="+Integer.MAX_VALUE; 
       return getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	}
	public String getDeployment(String deployId) throws Exception {
		 String serviceBase = "/repository/deployments/" + deployId;
		 return getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	      
	}
	public String getProcessDefinitions() throws Exception {
		String serviceBase ="/repository/process-definitions?start=0&size="+Integer.MAX_VALUE;
	    return getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	      
	}
	
	
	
	public String getProcessGraphUrl(String processKey) throws Exception{
		
		String serviceBase = "/repository/process-definitions?key=" + processKey+"&latest=true";
		
	    String processDefinition = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	    JSONObject json = JSON.parseObject(processDefinition);
	    
	    JSONArray data = json.getJSONArray("data");
	    JSONObject dataObjJson = data.getJSONObject(0);
	    
		String processDefinitionId = dataObjJson.getString("id");
		
		String processImageUrl = this.getExplorerServiceUrl() + "/diagram-viewer/index.html?processDefinitionId=" + processDefinitionId;
		
		
		
		return processImageUrl;
		
	}
	
	public String getProcessTrackGraphUrl(String businessKey) throws Exception{
        String serviceBase = "/history/historic-process-instances?businessKey="+businessKey;//添加参数assignee:只返回分配给指定用户的任务
        String processInstances = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
        JSONObject json = JSON.parseObject(processInstances);
	    JSONArray data = json.getJSONArray("data");
	    JSONObject dataObjJson = data.getJSONObject(0);
        
	    String processDefinitionId = dataObjJson.getString("processDefinitionId");
	    String processInstanceId= dataObjJson.getString("id");
		
		String processTrackGraphUrl = this.getExplorerServiceUrl() + "/diagram-viewer/index.html?processDefinitionId=" + processDefinitionId+"&processInstanceId="+processInstanceId;
		return processTrackGraphUrl;
	}
	
	public String getProcessDefinetionId(String processKey) throws Exception{
		String serviceBase = "/repository/process-definitions?key=" + processKey+"&latest=true";
	    String processDefinition = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	    JSONObject json = JSON.parseObject(processDefinition);
	    
	    JSONArray data = json.getJSONArray("data");
	    JSONObject dataObjJson = data.getJSONObject(0);
	    
		String processDefinitionId = dataObjJson.getString("id");
	    return processDefinitionId;
	}
	

	public String getProcessDefinitionById(String processDefinitionId) throws Exception {
		String serviceBase ="/repository/process-definitions/" + processDefinitionId;
		String jsonString = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
		return jsonString;    
	}
	
	public String getActivitiProcessTrackByProcessInstanceId(String processInstanceId) throws Exception {
		String activitiProcessTrackUrl = "/runtime/process-instances/"+processInstanceId+"/diagram";
		getDisposeUtil().getResponseForURLConnection("GET",activitiProcessTrackUrl);
		return activitiProcessTrackUrl;    
	}
	
	
	public String getProcessDefinitionByKey(String processDefinitionKey) {
		throw new RuntimeException("还未实现");
	      
	}
	public byte[] getProcessDefinitionImage(String processDefinitionId) throws Exception {
		   String serviceBase = "/repository/process-definitions/" + processDefinitionId;
	       String processDefinition = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	       JSONObject json = JSON.parseObject(processDefinition);
			String diagramResource = json.getString("diagramResource");

			String diagramResource2 = getDisposeUtil().getResponseForURLConnection("GET",diagramResource);
			
			String contentUrl= JSON.parseObject(diagramResource2).getString("contentUrl");
			getDisposeUtil().getResponseForURLConnection("GET",contentUrl);
			
			//byte[] image = this.getRestByte(contentUrl, HttpMethod.GET, null);
			
			//return image; 
			return null; 
	}
	
	
	public byte[] getProcessDefinitionImageByKey(String processKey) throws Exception {
		
		String processDefinitionId = getProcessDefinetionId(processKey);
		
		String serviceBase = "/repository/process-definitions/" + processDefinitionId;
        String processDefinition = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
        JSONObject json = JSON.parseObject(processDefinition);
		String diagramResource = json.getString("diagramResource");
		
		String diagramResource2 = getDisposeUtil().getResponseForURLConnection("GET",diagramResource);
		String contentUrl= JSON.parseObject(diagramResource2).getString("contentUrl");
		getDisposeUtil().getResponseForURLConnection("GET",contentUrl);
		
		//byte[] image = this.getRestByte(contentUrl, HttpMethod.GET, null);
		
		//return image; 
		return null;   
	}
	public String startProcessById(String processDefinitionId, String businessKey,JSONArray variables) throws Exception {
		log.debug("start process by id:" + processDefinitionId);
		String serviceBase = "/runtime/process-instances";
		JSONObject json = new JSONObject();
		json.put("processDefinitionId", processDefinitionId);
		json.put("businessKey", businessKey);
		json.put("variables", variables);
		String resp = getDisposeUtil().getResponseForURLConnectionParam("GET",serviceBase,json.toString());

	    return JSON.parseObject(resp).getString("id");
	      
	}
	public String startProcessByKey(String processDefinitionKey, String businessKey,JSONArray variables) throws Exception {
		log.debug("start process by key:" + processDefinitionKey);
		String serviceBase = "/runtime/process-instances";
		Map<String, String> variablesR = new HashMap();
/*		JSONObject json = new JSONObject();
		json.put("processDefinitionKey", processDefinitionKey);
		json.put("businessKey", businessKey);
//		json.put("tenantId", "testtenantId");
		json.put("variables", variables);*/
		
		variablesR.put("processDefinitionKey", processDefinitionKey);
		variablesR.put("businessKey", businessKey);//唯一约束，业务主键
        JSONObject startParams = new JSONObject();
        startParams.putAll(variablesR);
	    String resp = getDisposeUtil().getResponseForJsonURLConnection(serviceBase,"POST",startParams.toString());
	    log.debug("processInstance:" + resp);
	    return JSON.parseObject(resp).getString("id");
	}
	
	
	public String appointStartProcessByKey(String processDefinitionKey, String businessKey,JSONArray variables) throws Exception {
		log.debug("start process by key:" + processDefinitionKey);
		String serviceBase = "/runtime/process-instances";
		JSONObject json = new JSONObject();
		json.put("processDefinitionKey", processDefinitionKey);
		json.put("businessKey", businessKey);
//		json.put("tenantId", "testtenantId");
		json.put("variables", variables);
	    String resp = getDisposeUtil().getResponseForJsonURLConnection(serviceBase,"POST",json.toString());
	    log.debug("processInstance:" + resp);
	    return JSON.parseObject(resp).getString("id");
	}
	
	public void appointStartProcessByKey(String processDefinitionKey, String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables) throws Exception {
		startProcessByKey(processDefinitionKey,businessKey,null);
		this.appointCompleteTask(businessKey, assigneeOrRole,owner, description,variables);
	}
	public List<TaskInfo> getMyTask(String userId) throws Exception {
		String serviceBase = "/runtime/tasks?assignee="+userId;
	    String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	    log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<TaskInfo> list = new ArrayList<TaskInfo>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));
			list.add(new TaskInfo(data.getJSONObject(i)));
		}
		return list;
	}
	
	public List<String> getTodoBusinessKeyByAssignee(String userId) throws Exception {
		String serviceBase = "/runtime/tasks?assignee="+userId;
	    String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	    log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<String> list = new ArrayList<String>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));

			JSONObject jsonObj = this.getJsonObjProcessInstanceById(data.getJSONObject(i).getString("processInstanceId"));
			list.add(jsonObj.getString("businessKey"));
		}
		return list;
	}
	
	
	  /**
     * 通过实例ID获取流程实例
     * 参数：processInstanceId 流程实例ID
     *
     * @throws Exception
     */
    
    public JSONObject getJsonObjProcessInstanceById(String processInstanceId) throws Exception{
        String serviceBase = "/runtime/process-instances/"+processInstanceId;
	    String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
        JSONObject data = JSON.parseObject(resp);
        return  data;
    }
	
	public List<TaskInfo> getMyTask(String userId, String processDefinitionKey) throws Exception {
		log.debug("get my task userId:" + userId + " processDefinitionKey:" + processDefinitionKey);
		String serviceBase = "/runtime/tasks?assignee="+userId + "&processDefinitionKey=" + processDefinitionKey;
	    String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	    log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<TaskInfo> list = new ArrayList<TaskInfo>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));
			list.add(new TaskInfo(data.getJSONObject(i)));
		}
		return list;
	}
	
	
	public List<TaskInfo> getMyHistoryTask(String bussinessKey) throws Exception {
		String serviceBase = "/history/historic-task-instances?processBusinessKey="+bussinessKey+"&start=0&size="+Integer.MAX_VALUE;
	    String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	    log.debug("getMyHistoryTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<TaskInfo> list = new ArrayList<TaskInfo>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));
			list.add(new TaskInfo(data.getJSONObject(i)));
		}
		return list;
	}
	
	
	public List getCandidaTask(String userId) throws Exception {
		String serviceBase ="/query/tasks";
		JSONObject json = new JSONObject();
		json.put("candidateUser", userId);
		String resp = getDisposeUtil().getResponseForURLConnectionParam("POST", serviceBase, json.toString());
	    log.debug("candida:" + resp);
		JSONObject jsonTask  = JSON.parseObject(resp);
		return null;
	}

	public List getGroupTask(String userId) throws Exception {
		String serviceBase = "/identity/groups";
		JSONObject json = new JSONObject();
		json.put("member", userId);
		String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	    log.debug("groups:" + resp);
	    JSONObject jsonGroup = JSON.parseObject(resp);
	    JSONArray array = jsonGroup.getJSONArray("data");
	    String groups = "";
	    for (int i = 0; i < array.size(); i++){
	    	if (i > 0){
	    		groups += ",";
	    	}
	    	groups += array.getJSONObject(i).getString("id");
	    	
	    }
	    log.debug("groups:" + groups);
	    //这里只是跟任务有关的，比如admin、engineering、user三个组也会有任务，但是不在业务组中
	    this.getGroupTaskList("management,marketing,sales");
		return null;
	}
	public List getGroupTaskList(String groups) throws Exception {
		String serviceBase =  "/runtime/tasks?candidateGroups="+groups;
		JSONObject json = new JSONObject();
		String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
	    log.debug("groupTask:" + resp);
	    return null;
	}
	public void claimTask(String taskId, String userId) throws Exception {
		String serviceBase =  "/runtime/tasks/"+taskId;
		JSONObject json = new JSONObject();
		json.put("action", "claim");
		json.put("assignee", userId);
		getDisposeUtil().getResponseForJsonURLConnection(serviceBase,"POST",json.toString());
	}

	public void completeTask(String taskId,JSONArray variables) throws Exception {
		log.debug("complete task:" + taskId);
		String serviceBase =  "/runtime/tasks/"+taskId;
		//String   serviceBase = "/task/"+taskId+"/complete"; 
		JSONObject json = new JSONObject();
		json.put("action", "complete");
		//json.put("variables", variables);
		json.put("isAgree", 1);
		
/*        Map<String, String> variablesR = new HashMap();
        variablesR.put("action", "complete");
        variablesR.put("isAgree", "1");
        JSONObject comleteParams = new JSONObject();
        comleteParams.putAll(variablesR);*/
		
      
		String resp = getDisposeUtil().getResponseForJsonURLConnection(serviceBase,"POST",json.toString());
		log.debug("resp:" + resp);
	}
	
	public void updateTask(String taskId,String description,String owner) throws Exception {
		log.debug("complete task:" + taskId);
		String serviceBase =  "/runtime/tasks/"+taskId;
/*		JSONObject json = new JSONObject();
		json.put("description", description);//审批描述记录审批意见
		json.put("owner", owner);//任务拥有者
*/		
        Map<String, String> variablesR = new HashMap();
        variablesR.put("description", description);
        variablesR.put("owner", owner);
        JSONObject updateParams = new JSONObject();
        updateParams.putAll(variablesR);
		
		String resp = getDisposeUtil().getResponseForURLConnectionParam("PUT", serviceBase, updateParams.toString());
		log.debug("resp:" + resp);
	}
	
	
	@SuppressWarnings("unused")
	public int appointCompleteTask(String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables) throws Exception{
		int completeResult=0;
		//1)通过businessKey 获取当前运行task
		TaskInfo task = getTaskByBusinessKey(businessKey);
		completeTask(task.getTaskId(),variables);
		//2)执行审批
		TaskInfo taskR = getTaskByBusinessKey(businessKey);
		if(null!=taskR){
			updateTask(taskR.getTaskId(), description, owner);
			//3）给当前运行任务 指定办理者
			TaskInfo taskClaim = getTaskByBusinessKey(businessKey);
			claimTask(taskClaim.getTaskId(), assigneeOrRole);
		}else{
			updateTask(task.getTaskId(), description, owner);
			completeResult=1;
		}

		return completeResult;

	}
	
	public TaskInfo getTaskByBusinessKey(String businessKey) throws Exception{
		String serviceBase = "/runtime/tasks?processInstanceBusinessKey="+businessKey;
		String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
		log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		if(null==data||data.size()==0){
			return null;
		}else{
			return new TaskInfo(data.getJSONObject(0));
		}
	}

	public List getHistoryTask(String userId) {
		// TODO Auto-generated method stub
		return null;
	}
	public void addUser(String id, String firstName, String lastName, String email,String password) throws Exception{
		
		String serviceBase =  "/identity/users";
		JSONObject json = new JSONObject();
		json.put("id", id);
		json.put("firstName", firstName);
		json.put("lastName", lastName);
		json.put("email", email);
		json.put("password", password);
		String resp = getDisposeUtil().getResponseForURLConnectionParam("POST", serviceBase, json.toString());
		log.debug("add user resp:" + resp);
	}
	public void addUserToGroup(String userId, String groupId) throws Exception {
		String serviceBase =  "/identity/groups/" + groupId + "/members";
		JSONObject json = new JSONObject();
		json.put("userId", userId);
		String resp = getDisposeUtil().getResponseForURLConnectionParam("POST", serviceBase, json.toString());
		log.debug("add user to Group resp:" + resp);
	}

	
	
	public List<FlowElement> getFlowElementsByDefinitionId(String processDefinitionId) throws Exception{
		String serviceBase = "/repository/process-definitions/"+processDefinitionId+"/model";
	    String resp = getDisposeUtil().getResponseForURLConnection("GET",serviceBase);
		JSONObject json = JSON.parseObject(resp);
		String processes = json.getString("processes");
		JSONArray  processesJSONArray= JSONArray.parseArray(processes);
		
		JSONObject    jsonR = JSON.parseObject( processesJSONArray.get(0).toString());
		String flowElements = jsonR.getString("flowElements");
		JSONArray  flowElementsJSONArray= JSONArray.parseArray(flowElements);
		
		
		List<FlowElement> flowElementsR = new ArrayList<FlowElement>();
		
		for (int i = 0; i < flowElementsJSONArray.size(); i++) {
			JSONObject    flowElementsJson = JSON.parseObject(flowElementsJSONArray.get(i).toString());
			if(null!=flowElementsJson.getString("name")){
				//System.out.println(flowElementsJson.getString("id")+":"+flowElementsJson.getString("name"));
				flowElementsR.add(new FlowElement(flowElementsJson));
			}
		}
		return flowElementsR;
	}
	
}
