package com.jumipm.workflow.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jumipm.workflow.ProcessEngine;
import com.jumipm.workflow.utils.IntComparator;

/**
 * 
 * @author leasonlive
 *
 */
@Service("processEngine")
public class ProcessEngineImpl implements ProcessEngine {
	private static Log log = LogFactory.getLog(ProcessEngine.class);
/*	@Autowired(required=true)
	RestTemplate restTemplate;*/
	public static RestTemplate restTemplate = new RestTemplate();
	HttpHeaders headers;
	HttpEntity<String> _noParamEntity;
	String baseURI = null;
	String baseExplorerURI = null;
	
	
	public ProcessEngineImpl() {
		this.initHeader();
		this.initURI();
	}
	/**
	 * 初始化rest的请求头
	 */
	private void initHeader(){
		this.headers = new HttpHeaders();
		this.headers.setContentType(MediaType.APPLICATION_JSON);        
        String encodedToken = "Basic "+Base64.encodeBase64String("kermit:kermit".getBytes());
        this.headers.set("Authorization",encodedToken );
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		_noParamEntity = new HttpEntity<String>("", this.headers);
	}
	public HttpEntity<String> getHttpEntity(JSONObject json){
		if (json == null){
			return this._noParamEntity;
		} else {
			log.debug("json:" + json.toString());
			return new HttpEntity<String>(json.toString(), this.headers);
		}
	}
	
	/**
	 * 初始化工作流服务器的rest基本地址 180.168.15.99:8050
	 */
	private void initURI(){
/*		this.baseURI = "http://172.23.8.18:8090/activiti-rest/service";
		this.baseExplorerURI="http://172.23.8.18:8090/activiti-explorer";*/
/*		this.baseURI = "http://180.168.15.99:8050/activiti-rest/service";
		this.baseExplorerURI="http://180.168.15.99:8050/activiti-explorer";*/
		
/*		this.baseURI = "http://127.0.0.1:8050/activiti-rest/service";
		this.baseExplorerURI="http://127.0.0.1:8050/activiti-explorer";*/
		this.baseURI = getEngineServiceUrl();
		this.baseExplorerURI = getExplorerServiceUrl();
	}
	
	   /**
     * 获取引擎访问URL
     */
    public String getEngineServiceUrl() {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("application.properties");
        Properties prop = new Properties();
        String engineServiceUrl = "";
        try {
            prop.load(inStream);
            engineServiceUrl = prop.getProperty("flow.engineUrl").concat("/service");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return engineServiceUrl;
    }
    

    /**
     * 获取流程explorer访问URL
     */
    public String getExplorerServiceUrl() {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("application.properties");
        Properties prop = new Properties();
        String engineServiceUrl = "";
        try {
            prop.load(inStream);
            engineServiceUrl = prop.getProperty("explorer.engineUrl");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return engineServiceUrl;
    }
	
	
	public String getDeployments() {
       String serviceBase = this.baseURI + "/repository/process-definitions?latest=true&start=0&size="+Integer.MAX_VALUE;
       return this.getRestString(serviceBase, HttpMethod.GET, null);  
	}
	public String getDeployment(String deployId) {
		 String serviceBase = this.baseURI + "/repository/deployments/" + deployId;
		 return this.getRestString(serviceBase, HttpMethod.GET, null);
	      
	}
	public String getProcessDefinitions() {
		String serviceBase =this.baseURI + "/repository/process-definitions?start=0&size="+Integer.MAX_VALUE;
	    return this.getRestString(serviceBase, HttpMethod.GET, null);
	      
	}
	
	
	
	public String getProcessGraphUrl(String processKey){
		
		String serviceBase = this.baseURI + "/repository/process-definitions?key=" + processKey+"&latest=true";
	    String processDefinition = this.getRestString(serviceBase, HttpMethod.GET, null);
	    JSONObject json = JSON.parseObject(processDefinition);
	    
	    JSONArray data = json.getJSONArray("data");
	    JSONObject dataObjJson = data.getJSONObject(0);
	    
		String processDefinitionId = dataObjJson.getString("id");
		
		String processImageUrl = this.baseExplorerURI + "/diagram-viewer/index.html?processDefinitionId=" + processDefinitionId;
		return processImageUrl;
		
	}
	
	public String getProcessTrackGraphUrl(String businessKey){
        String serviceBase = this.baseURI + "/history/historic-process-instances?businessKey="+businessKey;//添加参数assignee:只返回分配给指定用户的任务
        String processInstances = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject json = JSON.parseObject(processInstances);
	    JSONArray data = json.getJSONArray("data");
	    JSONObject dataObjJson = data.getJSONObject(0);
        
	    String processDefinitionId = dataObjJson.getString("processDefinitionId");
	    String processInstanceId= dataObjJson.getString("id");
		
		String processTrackGraphUrl = this.baseExplorerURI + "/diagram-viewer/index.html?processDefinitionId=" + processDefinitionId+"&processInstanceId="+processInstanceId;
		return processTrackGraphUrl;
	}
	
	public String getProcessDefinetionId(String processKey){
		String serviceBase = this.baseURI + "/repository/process-definitions?key=" + processKey+"&latest=true";
	    String processDefinition = this.getRestString(serviceBase, HttpMethod.GET, null);
	    JSONObject json = JSON.parseObject(processDefinition);
	    
	    JSONArray data = json.getJSONArray("data");
	    JSONObject dataObjJson = data.getJSONObject(0);
	    
		String processDefinitionId = dataObjJson.getString("id");
	    return processDefinitionId;
	}
	
	/**
	 * 得到一个字节
	 * @param restURI
	 * @param method
	 * @param json
	 * @return
	 */
	private byte[] getRestByte(String restURI, HttpMethod method, JSONObject json){
		return restTemplate
        .exchange(restURI, method, this.getHttpEntity(json), byte[].class).getBody();
	}
	/**
	 * 得到一个字符串
	 * @param restURI
	 * @param method
	 * @param json
	 * @return
	 */
	private String getRestString(String restURI, HttpMethod method, JSONObject json ){
		try {
			byte[] bytes = this.getRestByte(restURI, method, json);
			if (bytes == null) {
				return null;
			}
			return new String(bytes,"UTF-8");
		} catch (RestClientException e) {
			throw new RuntimeException(e);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	public String getProcessDefinitionById(String processDefinitionId) {
		String serviceBase =this.baseURI + "/repository/process-definitions/" + processDefinitionId;
		return this.getRestString(serviceBase, HttpMethod.GET, null);    
	}
	
	public String getActivitiProcessTrackByProcessInstanceId(String processInstanceId) {
		String activitiProcessTrackUrl = this.baseURI + "/runtime/process-instances/"+processInstanceId+"/diagram";
		this.getRestString(activitiProcessTrackUrl, HttpMethod.GET, null);
		return activitiProcessTrackUrl;    
	}
	
	
	public String getProcessDefinitionByKey(String processDefinitionKey) {
		throw new RuntimeException("还未实现");
	      
	}
	public byte[] getProcessDefinitionImage(String processDefinitionId) {
		String serviceBase = this.baseURI + "/repository/process-definitions/" + processDefinitionId;
	       String processDefinition = this.getRestString(serviceBase, HttpMethod.GET, null);
	       JSONObject json = JSON.parseObject(processDefinition);
			String diagramResource = json.getString("diagramResource");
			
			String diagramResource2 = this.getRestString(diagramResource, HttpMethod.GET, null);
			String contentUrl= JSON.parseObject(diagramResource2).getString("contentUrl");
			byte[] image = this.getRestByte(contentUrl, HttpMethod.GET, null);
			
			return image;    
	}
	
	
	public byte[] getProcessDefinitionImageByKey(String processKey) {
		
		String processDefinitionId = getProcessDefinetionId(processKey);
		
		String serviceBase = this.baseURI + "/repository/process-definitions/" + processDefinitionId;
        String processDefinition = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject json = JSON.parseObject(processDefinition);
		String diagramResource = json.getString("diagramResource");
		
		String diagramResource2 = this.getRestString(diagramResource, HttpMethod.GET, null);
		String contentUrl= JSON.parseObject(diagramResource2).getString("contentUrl");
		byte[] image = this.getRestByte(contentUrl, HttpMethod.GET, null);
		
		return image;    
	}
	public String startProcessById(String processDefinitionId, String businessKey,JSONArray variables) {
		log.debug("start process by id:" + processDefinitionId);
		String serviceBase = this.baseURI + "/runtime/process-instances";
		JSONObject json = new JSONObject();
		json.put("processDefinitionId", processDefinitionId);
		json.put("businessKey", businessKey);
		json.put("variables", variables);
	    String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
	   return JSON.parseObject(resp).getString("id");
	      
	}
	public String startProcessByKey(String processDefinitionKey, String businessKey,JSONArray variables) {
		log.debug("start process by key:" + processDefinitionKey);
		String serviceBase = this.baseURI + "/runtime/process-instances";
		JSONObject json = new JSONObject();
		json.put("processDefinitionKey", processDefinitionKey);
		json.put("businessKey", businessKey);
//		json.put("tenantId", "testtenantId");
		json.put("variables", variables);
	    String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
	    log.debug("processInstance:" + resp);
	    return JSON.parseObject(resp).getString("id");
	}
	
	public String startProcessByDefinitionId(String processDefinitionId, String businessKey,JSONArray variables) {
		log.debug("start process by key:" + processDefinitionId);
		String serviceBase = this.baseURI + "/runtime/process-instances";
		JSONObject json = new JSONObject();
		json.put("processDefinitionId", processDefinitionId);
		json.put("businessKey", businessKey);
//		json.put("tenantId", "testtenantId");
		json.put("variables", variables);
	    String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
	    log.debug("processInstance:" + resp);
	    return JSON.parseObject(resp).getString("id");
	}
	
	
	public String appointStartProcessByKey(String processDefinitionKey, String businessKey,JSONArray variables) {
		log.debug("start process by key:" + processDefinitionKey);
		String serviceBase = this.baseURI + "/runtime/process-instances";
		JSONObject json = new JSONObject();
		json.put("processDefinitionKey", processDefinitionKey);
		json.put("businessKey", businessKey);
//		json.put("tenantId", "testtenantId");
		json.put("variables", variables);
	    String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
	    log.debug("processInstance:" + resp);
	    return JSON.parseObject(resp).getString("id");
	}
	
	public void appointStartProcessByKey(String processDefinitionKey, String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables) {
		startProcessByKey(processDefinitionKey,businessKey,null);
		TaskInfo taskInfo = this.getTaskByBusinessKey(businessKey);
		this.updateTask(taskInfo.getTaskId(), description, owner);
		this.appointCompleteTask(businessKey, assigneeOrRole,owner, description,variables);
	}
	public void appointStartProcessByDefinitionId(String processDefinitionId, String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables) {
		startProcessByDefinitionId(processDefinitionId,businessKey,null);
		TaskInfo taskInfo = this.getTaskByBusinessKey(businessKey);
		this.updateTask(taskInfo.getTaskId(), description, owner);
		this.appointCompleteTask(businessKey, assigneeOrRole,owner, description,variables);
	}
	public List<TaskInfo> getMyTask(String userId) {
		String serviceBase = this.baseURI + "/runtime/tasks?assignee="+userId+"&start=0&size="+Integer.MAX_VALUE;
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<TaskInfo> list = new ArrayList<TaskInfo>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));
			list.add(new TaskInfo(data.getJSONObject(i)));
		}
		return list;
	}
	
	public List<String> getTodoBusinessKeyByAssignee(String userId) {
		String serviceBase = this.baseURI + "/runtime/tasks?assignee="+userId+"&start=0&size="+Integer.MAX_VALUE;
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<String> list = new ArrayList<String>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));

			JSONObject jsonObj = this.getJsonObjProcessInstanceById(data.getJSONObject(i).getString("processInstanceId"));
			list.add(jsonObj.getString("businessKey"));
		}
		return list;
	}
	
	public List<String> getDoneBusinessKeyByAssignee(String taskAssignee) {
		String serviceBase = this.baseURI + "/history/historic-task-instances?taskAssignee="+taskAssignee+"&finished=true&start=0&size="+Integer.MAX_VALUE;//添加参数taskAssignee:历史任务实例的负责人
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<String> list = new ArrayList<String>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));

			JSONObject jsonObj = this.getJsonObjHisProcessInstanceById(data.getJSONObject(i).getString("processInstanceId"));
			list.add(jsonObj.getString("businessKey"));
		}
		return list;
	}
	
	
	  /**
     * 通过实例ID获取流程实例
     * 参数：processInstanceId 流程实例ID
     *
     * @throws Exception
     */
    
    public JSONObject getJsonObjProcessInstanceById(String processInstanceId){
        String serviceBase = this.baseURI + "/runtime/process-instances/"+processInstanceId;
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject data = JSON.parseObject(resp);
        return  data;
    }
    
	 /**
     * 通过实例ID获取流程实例
     * 参数：processInstanceId 流程实例ID
     *
     * @throws Exception
     */
    
    public JSONObject getJsonObjHisProcessInstanceById(String processInstanceId){
        String serviceBase = this.baseURI + "/history/historic-process-instances/"+processInstanceId;
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject data = JSON.parseObject(resp);
        return  data;
    }
	
	public List<TaskInfo> getMyTask(String userId, String processDefinitionKey) {
		log.debug("get my task userId:" + userId + " processDefinitionKey:" + processDefinitionKey);
		String serviceBase = this.baseURI + "/runtime/tasks?assignee="+userId + "&processDefinitionKey=" + processDefinitionKey;
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<TaskInfo> list = new ArrayList<TaskInfo>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));
			list.add(new TaskInfo(data.getJSONObject(i)));
		}
		return list;
	}
	
	
	public List<TaskInfo> getMyHistoryTask(String bussinessKey) {
		String serviceBase = this.baseURI + "/history/historic-task-instances?processBusinessKey="+bussinessKey;
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("getMyHistoryTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		List<TaskInfo> list = new ArrayList<TaskInfo>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));
			list.add(new TaskInfo(data.getJSONObject(i)));
		}
		return list;
	}
	
	
	public List getCandidaTask(String userId) {
		String serviceBase =this.baseURI + "/query/tasks";
		JSONObject json = new JSONObject();
		json.put("candidateUser", userId);
		String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
	    log.debug("candida:" + resp);
		JSONObject jsonTask  = JSON.parseObject(resp);
		return null;
	}

	public List getGroupTask(String userId) {
		String serviceBase = this.baseURI + "/identity/groups";
		JSONObject json = new JSONObject();
		json.put("member", userId);
		String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("groups:" + resp);
	    JSONObject jsonGroup = JSON.parseObject(resp);
	    JSONArray array = jsonGroup.getJSONArray("data");
	    String groups = "";
	    for (int i = 0; i < array.size(); i++){
	    	if (i > 0){
	    		groups += ",";
	    	}
	    	groups += array.getJSONObject(i).getString("id");
	    	
	    }
	    log.debug("groups:" + groups);
	    //这里只是跟任务有关的，比如admin、engineering、user三个组也会有任务，但是不在业务组中
	    this.getGroupTaskList("management,marketing,sales");
		return null;
	}
	public List getGroupTaskList(String groups) {
		String serviceBase =  this.baseURI+ "/runtime/tasks?candidateGroups="+groups;
		JSONObject json = new JSONObject();
		String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("groupTask:" + resp);
	    return null;
	}
	public void claimTask(String taskId, String userId) {
		String serviceBase =  this.baseURI+ "/runtime/tasks/"+taskId;
		JSONObject json = new JSONObject();
		json.put("action", "claim");
		json.put("assignee", userId);
		this.getRestString(serviceBase, HttpMethod.POST, json);
	}

	public void completeTask(String taskId,JSONArray variables) {
		log.debug("complete task:" + taskId);
		String serviceBase =  this.baseURI+ "/runtime/tasks/"+taskId;
		JSONObject json = new JSONObject();
		json.put("action", "complete");
		
		JSONArray variablesIn = new JSONArray();
		
		if(null!=variables){
			Iterator<Object> it = variables.iterator();
		    while (it.hasNext()) {
	            JSONObject ob = (JSONObject) it.next();
	            Iterator<String> sIterator = ob.keySet().iterator();
	            while(sIterator.hasNext()){  
	                // 获得key  
	                String key = sIterator.next();  
	                // 根据key获得value, value也可以是JSONObject,JSONArray,使用对应的参数接收即可  
	                String value = ob.getString(key);
	         		RestVariable restVariable = new RestVariable();
	        		restVariable.setName(key);
	        		restVariable.setValue(value);
	        		variablesIn.add(restVariable);
	        		json.put("variables", variablesIn);
	            }  
			 }		
		}
		System.out.println("--------------------------:"+json);
		String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
		log.debug("resp:" + resp);
	}
	
	public void updateTask(String taskId,String description,String owner) {
		log.debug("complete task:" + taskId);
		String serviceBase =  this.baseURI+ "/runtime/tasks/"+taskId;
		JSONObject json = new JSONObject();
		if(null!=description&&!("".equals(description))){
			json.put("description", description);//审批描述记录审批意见
		}
		if(null!=owner&&!("".equals(owner))){
			json.put("owner", owner);//任务拥有者
		}

		String resp = this.getRestString(serviceBase, HttpMethod.PUT, json);
		log.debug("resp:" + resp);
	}
	
	
	@SuppressWarnings("unused")
	public int appointCompleteTask(String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables){
		int completeResult=0;
		//1)通过businessKey 获取当前运行task
		TaskInfo task = getTaskByBusinessKey(businessKey);
		updateTask(task.getTaskId(), description, null);
		completeTask(task.getTaskId(),variables);
		//2)执行审批
		TaskInfo taskR = getTaskByBusinessKey(businessKey);
		if(null!=taskR){
			//3）给当前运行任务 指定办理者
			updateTask(taskR.getTaskId(), null, assigneeOrRole);
			TaskInfo taskClaim = getTaskByBusinessKey(businessKey);
			claimTask(taskClaim.getTaskId(), assigneeOrRole);
		}else{
			//updateTask(task.getTaskId(), description, owner);
			completeResult=1;
		}

		return completeResult;

	}
	
	public TaskInfo getTaskByBusinessKey(String businessKey){
		String serviceBase = this.baseURI + "/runtime/tasks?processInstanceBusinessKey="+businessKey;
		String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
		log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + data.size());
		if(null==data||data.size()==0){
			return null;
		}else{
			return new TaskInfo(data.getJSONObject(0));
		}
	}
	
	public TaskInfo getTaskByTaskId(String taskId){
		String serviceBase = this.baseURI + "/history/historic-task-instances/"+taskId;
		String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
		log.debug("getMyTask:" + resp);
		JSONObject json = JSON.parseObject(resp);
		//JSONArray data = json.getJSONArray("data");
		log.debug("data.length:" + json.size());
		if(null==json||json.size()==0){
			return null;
		}else{
			return new TaskInfo(json);
		}
	}
	
	

	public List getHistoryTask(String userId) {
		// TODO Auto-generated method stub
		return null;
	}
	public void addUser(String id, String firstName, String lastName, String email,String password){
		
		String serviceBase =  this.baseURI+ "/identity/users";
		JSONObject json = new JSONObject();
		json.put("id", id);
		json.put("firstName", firstName);
		json.put("lastName", lastName);
		json.put("email", email);
		json.put("password", password);
		String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
		log.debug("add user resp:" + resp);
	}
	public void addUserToGroup(String userId, String groupId) {
		String serviceBase =  this.baseURI+ "/identity/groups/" + groupId + "/members";
		JSONObject json = new JSONObject();
		json.put("userId", userId);
		String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
		log.debug("add user to Group resp:" + resp);
	}

	
	
	@SuppressWarnings("unchecked")
	public List<FlowElement> getFlowElementsByDefinitionId(String processDefinitionId){
		String serviceBase = this.baseURI + "/repository/process-definitions/"+processDefinitionId+"/model";
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
		JSONObject json = JSON.parseObject(resp);
		String processes = json.getString("processes");
		
		JSONArray  processesJSONArray= JSONArray.parseArray(processes);
		
		JSONObject    jsonR = JSON.parseObject( processesJSONArray.get(0).toString());
		String flowElements = jsonR.getString("flowElements");
		String locationMap = json.getString("locationMap");
		JSONArray  flowElementsJSONArray= JSONArray.parseArray(flowElements);
		JSONObject  locationMapJSONArray= JSON.parseObject(locationMap);
		
		
		List<FlowElement> flowElementsR = new ArrayList<FlowElement>();
		List<FlowElement> flowElementsOut = new ArrayList<FlowElement>();
		String startTaskNode="";
		for (int i = 0; i < flowElementsJSONArray.size(); i++) {
			JSONObject    flowElementsJson = JSON.parseObject(flowElementsJSONArray.get(i).toString());
			/*if(null!=flowElementsJson.getString("name")){
				JSONObject  xCc= JSON.parseObject(locationMapJSONArray.getString(flowElementsJson.getString("id")));
				flowElementsJson.put("x", xCc.getString("x"));
				JSONArray  incomingFlowsJSONArray= JSONArray.parseArray(flowElementsJson.getString("incomingFlows"));
				JSONArray  outgoingFlowsJSONArray= JSONArray.parseArray(flowElementsJson.getString("outgoingFlows"));
				JSONObject incomingFlowsJson = JSON.parseObject(incomingFlowsJSONArray.get(0).toString());
				JSONObject outgoingFlowsJson = JSON.parseObject(outgoingFlowsJSONArray.get(0).toString());
				flowElementsJson.put("sourceRef", outgoingFlowsJson.getString("sourceRef"));
				flowElementsJson.put("targetRef", outgoingFlowsJson.getString("targetRef"));
				//System.out.println(flowElementsJson.getString("id")+":"+flowElementsJson.getString("name"));
				flowElementsR.add(new FlowElement(flowElementsJson));
			}*/
			JSONArray  incomingFlowsJSONArray= JSONArray.parseArray(flowElementsJson.getString("incomingFlows"));
			if(incomingFlowsJSONArray.size()==0){
				JSONArray  outgoingFlowsJSONArray= JSONArray.parseArray(flowElementsJson.getString("outgoingFlows"));
				JSONObject outgoingFlowsJson = JSON.parseObject(outgoingFlowsJSONArray.get(0).toString());
				startTaskNode=outgoingFlowsJson.getString("targetRef");
				break;
			}
		}
		
		Map<String,Object> map = new HashMap<String,Object>();
		for (int  j = 0; j  < flowElementsJSONArray.size(); j ++) {
			JSONObject    flowElementsJson = JSON.parseObject(flowElementsJSONArray.get(j).toString());
			if(null!=flowElementsJson.getString("name")){
				JSONObject  xCc= JSON.parseObject(locationMapJSONArray.getString(flowElementsJson.getString("id")));
				flowElementsJson.put("x", xCc.getString("x"));
				JSONArray  incomingFlowsJSONArray= JSONArray.parseArray(flowElementsJson.getString("incomingFlows"));
				JSONArray  outgoingFlowsJSONArray= JSONArray.parseArray(flowElementsJson.getString("outgoingFlows"));
				JSONObject incomingFlowsJson = JSON.parseObject(incomingFlowsJSONArray.get(0).toString());
				JSONObject outgoingFlowsJson = JSON.parseObject(outgoingFlowsJSONArray.get(0).toString());
				flowElementsJson.put("sourceRef", outgoingFlowsJson.getString("sourceRef"));
				flowElementsJson.put("targetRef", outgoingFlowsJson.getString("targetRef"));
				//System.out.println(flowElementsJson.getString("id")+":"+flowElementsJson.getString("name"));
				map.put(flowElementsJson.getString("id"), new FlowElement(flowElementsJson));
			}
		}

		sortFlowTask(startTaskNode,map,flowElementsOut);

		//根据坐标节点x排序
		//Collections.sort(flowElementsR,new IntComparator());
		//return flowElementsR;
		return flowElementsOut;
	}
	/**
	 * @param startTaskNode 第一个节点
	 * @param flowElementsIn 
	 * @param flowElementsOut
	 */
	public void sortFlowTask(String startTaskNode,Map<String,Object> map,List<FlowElement> flowElementsOut){
		flowElementsOut.add((FlowElement)map.get(startTaskNode));
		String targetTask = ((FlowElement)map.get(startTaskNode)).getTargetRef();
		if(null==map.get(targetTask)){
			return;
		}else{
			sortFlowTask(targetTask,map,flowElementsOut);
		}
	}
	
	
	
	
	/**
	 * 获取模型列表
	 * @param start  显示的起始页数
	 * @param  size  每页显示的最大数目
	 * return Map  key=total时为记录总数，key=list为根据条件查询数据列表
	 */
	public   Map<String,Object>  getModels(int start,int size) {
		Map<String,Object>  dataMap= new HashMap<String,Object>();
		String serviceBase = this.baseURI + "/repository/models?sort=createTime&order=desc&size="+size+"&start="+start;
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("getModels:" + resp);
		JSONObject json = JSON.parseObject(resp);
		JSONArray data = json.getJSONArray("data");
		
		log.debug("data.length:" + data.size());
		List<ModelInfo> list = new ArrayList<ModelInfo>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));
			list.add(new ModelInfo(data.getJSONObject(i)));
		}
		dataMap.put("list", list);
		dataMap.put("total", json.get("total"));
		return dataMap;
	}
	/**
	 * 根据ID 删除模型
	 * @param ModelId  要删除的modelid
	 * @param  size  每页显示的最大数目
	 * return Map  key=total时为记录总数，key=list为根据条件查询数据列表
	 */
	public void deleteModel(String modelId) {
		String serviceBase =  this.baseURI+ "/repository/models/"+modelId;
	    this.getRestString(serviceBase, HttpMethod.DELETE, null);
	}
	
	/**
	 * 获取代办任务信息
	 * 
	 * ***/
	public   boolean isHaveTasks(String processDefinitionId) {
		String serviceBase = this.baseURI + "/runtime/tasks?processDefinitionId="+processDefinitionId+"&size="+Integer.MAX_VALUE+"&start=0";
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("isHaveTasks:" + resp);
		JSONObject json = JSON.parseObject(resp);
		System.out.println(json);
		JSONArray data = json.getJSONArray("data");
		
		log.debug("data.length:" + data.size());
		List<ModelInfo> list = new ArrayList<ModelInfo>();
		if(data.size()>0){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * 通过部署id判断是否有待处理任务
	 * 
	 * 0:标识没有待处理任务，1标识有待处理任务
	 * 
	 * ***/
	public  int isHaveTasksByDeploymentId(String deploymentId) {
		String serviceBase = this.baseURI + "/repository/process-definitions?deploymentId="+deploymentId+"&size="+Integer.MAX_VALUE+"&start=0";
	    String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
	    log.debug("getProcessDefinitionsByDeploymentId:" + resp);
		JSONObject json = JSON.parseObject(resp);
		System.out.println(json);
		JSONArray data = json.getJSONArray("data");
		int isHaveTaskByDeploymentId=0;
		log.debug("data.length:" + data.size());
		List<ModelInfo> list = new ArrayList<ModelInfo>();
		for (int i = 0; i < data.size(); i++){
			log.debug("data[" + i + "]:" + data.getJSONObject(i));
			String processDefinitionId = data.getJSONObject(i).getString("processDefinitionId");
			if(isHaveTasks(processDefinitionId)){
				isHaveTaskByDeploymentId=1;
				break;
			}
		}
		return isHaveTaskByDeploymentId;
	}
		
}
