/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.commons.redisson;

import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class RedissonDelayQueue {
    private static final Logger log = LoggerFactory.getLogger(RedissonDelayQueue.class);
    @Value(value="${redis.pass}")
    private String Address;
    private String Database;
    private String password;
    private RedissonClient redissonClient;
    private RDelayedQueue<String> delayQueue;
    private RBlockingQueue<String> blockingQueue;
    private String name = "";

    public void init(String name) {
        this.name = name;
        this.initDelayQueue();
        this.startDelayQueueConsumer();
    }

    private void initDelayQueue() {
        Config config = new Config();
        SingleServerConfig serverConfig = config.useSingleServer();
        serverConfig.setAddress("redis://localhost:6379");
        serverConfig.setDatabase(10);
        serverConfig.setPassword("jmkj@666");
        serverConfig.setTimeout(3000);
        this.redissonClient = Redisson.create((Config)config);
        this.blockingQueue = this.redissonClient.getBlockingQueue("SANYOU");
        this.delayQueue = this.redissonClient.getDelayedQueue(this.blockingQueue);
    }

    private void startDelayQueueConsumer() {
        new Thread(() -> {
            log.info(">>>>>>>>>>>>>>>>Thread");
            while (true) {
                log.info(">>>>>>>>>>>>>>>>");
                try {
                    String task = (String)this.blockingQueue.take();
                    log.info("\u63a5\u6536\u5230\u5ef6\u8fdf\u4efb\u52a1:{}", (Object)task);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, this.name + "SANYOU-Consumer").start();
    }

    public void offerTask(String task, long seconds) {
        log.info("\u6dfb\u52a0\u5ef6\u8fdf\u4efb\u52a1:{} \u5ef6\u8fdf\u65f6\u95f4:{}s", (Object)task, (Object)seconds);
        this.delayQueue.offer((Object)task, seconds, TimeUnit.SECONDS);
    }
}

