/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.redisson;

import com.jumipm.common.redisson.DelayQueueConsumer;
import com.jumipm.common.redisson.MessageModel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RedissonDelayQueue {
    private static final Logger log = LoggerFactory.getLogger(RedissonDelayQueue.class);
    private RedissonClient redissonClient;
    private ThreadPoolExecutor taskExecutor;
    private Map<String, DelayQueueConsumer> consumers = new ConcurrentHashMap<String, DelayQueueConsumer>();
    private RDelayedQueue<MessageModel> delayQueue;
    private RBlockingQueue<MessageModel> blockingQueue;
    private Long defaultTime = 10L;
    private String name = "Jumi_DelayQueue";

    public RedissonDelayQueue(List<DelayQueueConsumer> consumerList, RedissonClient redissonClient) {
        if (!CollectionUtils.isEmpty(consumerList)) {
            for (int i = 0; i < consumerList.size(); ++i) {
                DelayQueueConsumer consumer = consumerList.get(i);
                this.consumers.put(consumer.getType(), consumer);
            }
        }
        this.redissonClient = redissonClient;
        this.taskExecutor = new ThreadPoolExecutor(0, 5, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void init(String name) {
        this.name = name;
        this.initDelayQueue();
        this.startDelayQueueConsumer();
    }

    private void initDelayQueue() {
        this.blockingQueue = this.redissonClient.getBlockingQueue(this.name);
        this.delayQueue = this.redissonClient.getDelayedQueue(this.blockingQueue);
    }

    private void startDelayQueueConsumer() {
        new Thread(() -> {
            log.info("startDelayQueueConsumer Thread>>>>>>>>>>>>>>>>");
            while (true) {
                log.info("wait message >>>>>>>>>>>>>>>>");
                try {
                    MessageModel task = (MessageModel)this.blockingQueue.take();
                    log.info("\u63a5\u6536\u5230\u5ef6\u8fdf\u4efb\u52a1:{}", (Object)task.getType());
                    this.accept(task);
                }
                catch (Exception ex) {
                    log.error("\u6267\u884c\u5931\u8d25: {}", (Object)ex.getMessage());
                    ex.printStackTrace();
                    return;
                }
            }
        }, this.name + "-Consumer").start();
    }

    public void sendDelayTask(MessageModel task, long seconds) {
        log.info("\u6dfb\u52a0\u5ef6\u8fdf\u4efb\u52a1:{} \u5ef6\u8fdf\u65f6\u95f4:{}s", (Object)task.getType(), (Object)seconds);
        this.delayQueue.offer((Object)task, seconds, TimeUnit.SECONDS);
    }

    public void sendDelayTask(MessageModel task) {
        this.sendDelayTask(task, this.defaultTime);
    }

    public void sendTask(MessageModel task) {
        log.info("\u6dfb\u52a0\u5b9e\u65f6\u4efb\u52a1:{}", (Object)task.getType());
        this.accept(task);
    }

    private void accept(MessageModel msg) {
        log.info("MessageModel type is {}", (Object)msg.getType());
        if (!this.consumers.containsKey(msg.getType())) {
            log.warn("no consumer type of {}", (Object)msg.getType());
            return;
        }
        CompletionStage exceptionally = CompletableFuture.runAsync(() -> {
            Thread.currentThread().setName(String.format("DelayQueueConsumer-%s", msg.getType()));
            log.info("\u5f00\u59cb\u5904\u7406>>>>>>>");
            this.consumers.get(msg.getType()).accept(msg);
            log.info("\u5904\u7406\u5b8c\u6210>>>>>>>");
        }, this.taskExecutor).exceptionally(error -> {
            log.error("\u6267\u884c\u5931\u8d25: {}", (Object)error.getMessage());
            error.printStackTrace();
            return null;
        });
        log.info("isDone {}", (Object)((CompletableFuture)exceptionally).isDone());
    }
}

