/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.delegate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementExistException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.exceptions.MetaStoreNamespaceExistsException;
import org.pentaho.metastore.api.security.Base64TwoWayPasswordEncoder;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.ITwoWayPasswordEncoder;
import org.pentaho.metastore.api.security.MetaStoreElementOwnerType;

public class DelegatingMetaStore
implements IMetaStore {
    protected List<IMetaStore> metaStoreList;
    protected String activeMetaStoreName;
    protected ITwoWayPasswordEncoder passwordEncoder;

    public DelegatingMetaStore() {
        this.metaStoreList = new ArrayList<IMetaStore>();
        this.passwordEncoder = new Base64TwoWayPasswordEncoder();
    }

    public DelegatingMetaStore(IMetaStore ... stores) {
        this.metaStoreList = new ArrayList<IMetaStore>(Arrays.asList(stores));
        this.passwordEncoder = new Base64TwoWayPasswordEncoder();
    }

    public void addMetaStore(IMetaStore metaStore) throws MetaStoreException {
        this.metaStoreList.add(metaStore);
    }

    public void addMetaStore(int index, IMetaStore metaStore) throws MetaStoreException {
        this.metaStoreList.add(index, metaStore);
    }

    public boolean removeMetaStore(IMetaStore metaStore) throws MetaStoreException {
        return this.removeMetaStore(metaStore.getName());
    }

    public List<IMetaStore> getMetaStoreList() {
        return this.metaStoreList;
    }

    public void setMetaStoreList(List<IMetaStore> metaStoreList) {
        this.metaStoreList = metaStoreList;
    }

    private List<IMetaStore> getReadMetaStoreList() throws MetaStoreException {
        if (this.activeMetaStoreName != null) {
            return Arrays.asList(this.getMetaStore(this.activeMetaStoreName));
        }
        return this.metaStoreList;
    }

    private IMetaStore getWriteMetaStore() throws MetaStoreException {
        if (this.activeMetaStoreName != null) {
            IMetaStore activeMetaStore = this.getMetaStore(this.activeMetaStoreName);
            if (activeMetaStore != null) {
                return activeMetaStore;
            }
            throw new MetaStoreException("Active metaStore could not be found but required for write operations.");
        }
        throw new MetaStoreException("Active metaStore not set but required for write operations.");
    }

    public boolean removeMetaStore(String metaStoreName) throws MetaStoreException {
        Iterator<IMetaStore> it = this.metaStoreList.iterator();
        while (it.hasNext()) {
            IMetaStore store = it.next();
            if (!store.getName().equalsIgnoreCase(metaStoreName)) continue;
            it.remove();
            if (this.activeMetaStoreName != null && metaStoreName.equalsIgnoreCase(this.activeMetaStoreName)) {
                this.activeMetaStoreName = null;
            }
            return true;
        }
        return false;
    }

    public void setActiveMetaStoreName(String activeMetaStoreName) {
        this.activeMetaStoreName = activeMetaStoreName;
    }

    public String getActiveMetaStoreName() {
        return this.activeMetaStoreName;
    }

    public IMetaStore getActiveMetaStore() throws MetaStoreException {
        if (this.activeMetaStoreName == null) {
            return null;
        }
        IMetaStore metaStore = this.getMetaStore(this.activeMetaStoreName);
        return metaStore;
    }

    public IMetaStore getMetaStore(String metaStoreName) throws MetaStoreException {
        for (IMetaStore metaStore : this.metaStoreList) {
            if (!metaStore.getName().equalsIgnoreCase(metaStoreName)) continue;
            return metaStore;
        }
        return null;
    }

    @Override
    public boolean namespaceExists(String namespace) throws MetaStoreException {
        for (IMetaStore metaStore : this.getReadMetaStoreList()) {
            if (!metaStore.namespaceExists(namespace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getNamespaces() throws MetaStoreException {
        HashSet<String> namespaceSet = new HashSet<String>();
        ArrayList<String> namespaces = new ArrayList<String>();
        for (IMetaStore metaStore : this.getReadMetaStoreList()) {
            for (String namespace : metaStore.getNamespaces()) {
                if (!namespaceSet.add(namespace)) continue;
                namespaces.add(namespace);
            }
        }
        return namespaces;
    }

    @Override
    public void createNamespace(String namespace) throws MetaStoreException, MetaStoreNamespaceExistsException {
        IMetaStore metaStore = this.getWriteMetaStore();
        metaStore.createNamespace(namespace);
    }

    @Override
    public void deleteNamespace(String namespace) throws MetaStoreException {
        IMetaStore metaStore = this.getWriteMetaStore();
        metaStore.deleteNamespace(namespace);
    }

    private IMetaStoreElementType getElementTypeByName(List<IMetaStoreElementType> types, String name) {
        for (IMetaStoreElementType type : types) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    @Override
    public List<IMetaStoreElementType> getElementTypes(String namespace) throws MetaStoreException {
        ArrayList<IMetaStoreElementType> elementTypes = new ArrayList<IMetaStoreElementType>();
        for (IMetaStore metaStore : this.getReadMetaStoreList()) {
            for (IMetaStoreElementType elementType : metaStore.getElementTypes(namespace)) {
                if (this.getElementTypeByName(elementTypes, elementType.getName()) != null) continue;
                elementTypes.add(elementType);
            }
        }
        return elementTypes;
    }

    @Override
    public List<String> getElementTypeIds(String namespace) throws MetaStoreException {
        ArrayList<String> elementTypeIds = new ArrayList<String>();
        for (IMetaStoreElementType elementType : this.getElementTypes(namespace)) {
            elementTypeIds.add(elementType.getId());
        }
        return elementTypeIds;
    }

    @Override
    public IMetaStoreElementType getElementType(String namespace, String elementTypeId) throws MetaStoreException {
        for (IMetaStoreElementType type : this.getElementTypes(namespace)) {
            if (!type.getId().equals(elementTypeId)) continue;
            return type;
        }
        return null;
    }

    @Override
    public IMetaStoreElementType getElementTypeByName(String namespace, String elementTypeName) throws MetaStoreException {
        return this.getElementTypeByName(this.getElementTypes(namespace), elementTypeName);
    }

    @Override
    public void createElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreElementTypeExistsException {
        IMetaStore metaStore = this.getWriteMetaStore();
        metaStore.createElementType(namespace, elementType);
    }

    @Override
    public void updateElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        IMetaStore metaStore = this.getWriteMetaStore();
        metaStore.updateElementType(namespace, elementType);
    }

    @Override
    public void deleteElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreDependenciesExistsException {
        IMetaStore metaStore = this.getWriteMetaStore();
        metaStore.deleteElementType(namespace, elementType);
    }

    private IMetaStoreElement getElementByName(List<IMetaStoreElement> elements, String name) {
        for (IMetaStoreElement element : elements) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    @Override
    public List<IMetaStoreElement> getElements(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        ArrayList<IMetaStoreElement> elements = new ArrayList<IMetaStoreElement>();
        for (IMetaStore metaStore : this.getReadMetaStoreList()) {
            IMetaStoreElementType localElementType = metaStore.getElementTypeByName(namespace, elementType.getName());
            if (localElementType == null) continue;
            for (IMetaStoreElement element : metaStore.getElements(namespace, localElementType)) {
                if (this.getElementByName(elements, element.getName()) != null) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    @Override
    public List<String> getElementIds(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        ArrayList<String> elementIds = new ArrayList<String>();
        for (IMetaStoreElement element : this.getElements(namespace, elementType)) {
            elementIds.add(element.getId());
        }
        return elementIds;
    }

    @Override
    public IMetaStoreElement getElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        for (IMetaStore localStore : this.getReadMetaStoreList()) {
            IMetaStoreElementType localType;
            if (elementType.getMetaStoreName() != null && !elementType.getMetaStoreName().equals(localStore.getName()) || (localType = localStore.getElementTypeByName(namespace, elementType.getName())) == null) continue;
            for (IMetaStoreElement element : localStore.getElements(namespace, localType)) {
                if (!element.getId().equals(elementId)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public IMetaStoreElement getElementByName(String namespace, IMetaStoreElementType elementType, String name) throws MetaStoreException {
        return this.getElementByName(this.getElements(namespace, elementType), name);
    }

    @Override
    public void createElement(String namespace, IMetaStoreElementType elementType, IMetaStoreElement element) throws MetaStoreException, MetaStoreElementExistException {
        this.getWriteMetaStore().createElement(namespace, elementType, element);
    }

    @Override
    public void deleteElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        this.getWriteMetaStore().deleteElement(namespace, elementType, elementId);
    }

    @Override
    public void updateElement(String namespace, IMetaStoreElementType elementType, String elementId, IMetaStoreElement element) throws MetaStoreException {
        this.getWriteMetaStore().updateElement(namespace, elementType, elementId, element);
    }

    @Override
    public IMetaStoreElementType newElementType(String namespace) throws MetaStoreException {
        return this.getWriteMetaStore().newElementType(namespace);
    }

    @Override
    public IMetaStoreElement newElement() throws MetaStoreException {
        return this.getWriteMetaStore().newElement();
    }

    @Override
    public IMetaStoreElement newElement(IMetaStoreElementType elementType, String id, Object value) throws MetaStoreException {
        return this.getWriteMetaStore().newElement(elementType, id, value);
    }

    @Override
    public IMetaStoreAttribute newAttribute(String id, Object value) throws MetaStoreException {
        return this.getWriteMetaStore().newAttribute(id, value);
    }

    @Override
    public IMetaStoreElementOwner newElementOwner(String name, MetaStoreElementOwnerType ownerType) throws MetaStoreException {
        return this.getWriteMetaStore().newElementOwner(name, ownerType);
    }

    @Override
    public String getName() throws MetaStoreException {
        IMetaStore activeMetaStore = this.getActiveMetaStore();
        if (activeMetaStore != null) {
            return activeMetaStore.getName();
        }
        return "DelegatingMetaStore";
    }

    @Override
    public String getDescription() throws MetaStoreException {
        IMetaStore activeMetaStore = this.getActiveMetaStore();
        if (activeMetaStore != null) {
            return activeMetaStore.getDescription();
        }
        return "The DelegatingMetaStore can act as a read-only aggregation of multiple MetaStores and can write if an active one is set";
    }

    @Override
    public void setTwoWayPasswordEncoder(ITwoWayPasswordEncoder encoder) {
        this.passwordEncoder = encoder;
    }

    @Override
    public ITwoWayPasswordEncoder getTwoWayPasswordEncoder() {
        return this.passwordEncoder;
    }
}

