/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.memory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.metastore.api.BaseMetaStore;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementExistException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.exceptions.MetaStoreNamespaceExistsException;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.MetaStoreElementOwnerType;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreAttribute;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElement;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElementOwner;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElementType;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreNamespace;
import org.pentaho.metastore.util.MetaStoreUtil;

public class MemoryMetaStore
extends BaseMetaStore
implements IMetaStore {
    private final Map<String, MemoryMetaStoreNamespace> namespacesMap = new HashMap<String, MemoryMetaStoreNamespace>();
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public MemoryMetaStore() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public List<String> getNamespaces() throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return new ArrayList<String>(MemoryMetaStore.this.namespacesMap.keySet());
            }
        });
    }

    @Override
    public boolean namespaceExists(final String namespace) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return MemoryMetaStore.this.namespacesMap.get(namespace) != null;
            }
        });
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MemoryMetaStore)) {
            return false;
        }
        return ((MemoryMetaStore)obj).name.equalsIgnoreCase(this.name);
    }

    @Override
    public void createNamespace(final String namespace) throws MetaStoreException, MetaStoreNamespaceExistsException {
        MetaStoreUtil.executeLockedOperation(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (MemoryMetaStore.this.namespacesMap.containsKey(namespace)) {
                    throw new MetaStoreNamespaceExistsException("Unable to create namespace '" + namespace + "' as it already exists!");
                }
                MemoryMetaStoreNamespace storeNamespace = new MemoryMetaStoreNamespace(namespace);
                MemoryMetaStore.this.namespacesMap.put(namespace, storeNamespace);
                return null;
            }
        });
    }

    @Override
    public void deleteNamespace(final String namespace) throws MetaStoreException, MetaStoreDependenciesExistsException {
        MetaStoreUtil.executeLockedOperation(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                final MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace == null) {
                    throw new MetaStoreException("Unable to delete namespace '" + namespace + "' as it doesn't exist");
                }
                MetaStoreUtil.executeLockedOperation(storeNamespace.getReadLock(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        List<String> elementTypeIds = storeNamespace.getElementTypeIds();
                        if (!elementTypeIds.isEmpty()) {
                            throw new MetaStoreDependenciesExistsException(elementTypeIds, "Namespace '" + namespace + "' is not empty!");
                        }
                        MemoryMetaStore.this.namespacesMap.remove(namespace);
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public List<IMetaStoreElementType> getElementTypes(final String namespace) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<List<IMetaStoreElementType>>(){

            @Override
            public List<IMetaStoreElementType> call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace != null) {
                    return storeNamespace.getElementTypes();
                }
                return Collections.emptyList();
            }
        });
    }

    @Override
    public IMetaStoreElementType getElementType(final String namespace, final String elementTypeId) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<IMetaStoreElementType>(){

            @Override
            public IMetaStoreElementType call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace != null) {
                    return storeNamespace.getElementTypeById(elementTypeId);
                }
                return null;
            }
        });
    }

    @Override
    public IMetaStoreElementType getElementTypeByName(final String namespace, final String elementTypeName) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<IMetaStoreElementType>(){

            @Override
            public IMetaStoreElementType call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace != null) {
                    return storeNamespace.getElementTypeByName(elementTypeName);
                }
                return null;
            }
        });
    }

    @Override
    public List<String> getElementTypeIds(final String namespace) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace != null) {
                    return storeNamespace.getElementTypeIds();
                }
                return Collections.emptyList();
            }
        });
    }

    @Override
    public void createElementType(final String namespace, final IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreElementTypeExistsException {
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace == null) {
                    throw new MetaStoreException("Namespace '" + namespace + "' doesn't exist!");
                }
                storeNamespace.createElementType(MemoryMetaStore.this.getName(), elementType);
                return null;
            }
        });
    }

    @Override
    public void updateElementType(final String namespace, final IMetaStoreElementType elementType) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace == null) {
                    throw new MetaStoreException("Namespace '" + namespace + "' doesn't exist!");
                }
                storeNamespace.updateElementType(MemoryMetaStore.this.getName(), elementType);
                return null;
            }
        });
    }

    @Override
    public void deleteElementType(final String namespace, final IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreDependenciesExistsException {
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace == null) {
                    throw new MetaStoreException("Namespace '" + namespace + "' doesn't exist!");
                }
                storeNamespace.deleteElementType(elementType);
                return null;
            }
        });
    }

    @Override
    public List<IMetaStoreElement> getElements(final String namespace, final IMetaStoreElementType elementType) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<List<IMetaStoreElement>>(){

            @Override
            public List<IMetaStoreElement> call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace != null) {
                    return storeNamespace.getElementsByElementTypeName(elementType.getName());
                }
                return Collections.emptyList();
            }
        });
    }

    @Override
    public List<String> getElementIds(final String namespace, final IMetaStoreElementType elementType) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace != null) {
                    return storeNamespace.getElementIdsByElementTypeName(elementType.getName());
                }
                return Collections.emptyList();
            }
        });
    }

    @Override
    public IMetaStoreElement getElement(final String namespace, final IMetaStoreElementType elementType, final String elementId) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<IMetaStoreElement>(){

            @Override
            public IMetaStoreElement call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace != null) {
                    return storeNamespace.getElementByTypeNameId(elementType.getName(), elementId);
                }
                return null;
            }
        });
    }

    @Override
    public IMetaStoreElement getElementByName(final String namespace, final IMetaStoreElementType elementType, final String name) throws MetaStoreException {
        return MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<IMetaStoreElement>(){

            @Override
            public IMetaStoreElement call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace != null) {
                    return storeNamespace.getElementByNameTypeName(elementType.getName(), name);
                }
                return null;
            }
        });
    }

    @Override
    public void createElement(final String namespace, final IMetaStoreElementType elementType, final IMetaStoreElement element) throws MetaStoreException, MetaStoreElementExistException {
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace == null) {
                    throw new MetaStoreException("Namespace '" + namespace + "' doesn't exist!");
                }
                storeNamespace.createElement(elementType, element);
                return null;
            }
        });
    }

    @Override
    public void updateElement(final String namespace, final IMetaStoreElementType elementType, final String elementId, final IMetaStoreElement element) throws MetaStoreException {
        if (elementType.getMetaStoreName() == null || !elementType.getMetaStoreName().equals(this.getName())) {
            throw new MetaStoreException("The element type '" + elementType.getName() + "' needs to explicitly belong to the meta store in which you are updating.");
        }
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace == null) {
                    throw new MetaStoreException("Namespace '" + namespace + "' doesn't exist!");
                }
                storeNamespace.updateElement(elementType, elementId, element);
                return null;
            }
        });
    }

    @Override
    public void deleteElement(final String namespace, final IMetaStoreElementType elementType, final String elementId) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreNamespace storeNamespace = (MemoryMetaStoreNamespace)MemoryMetaStore.this.namespacesMap.get(namespace);
                if (storeNamespace == null) {
                    throw new MetaStoreException("Namespace '" + namespace + "' doesn't exist!");
                }
                storeNamespace.deleteElement(elementType, elementId);
                return null;
            }
        });
    }

    @Override
    public IMetaStoreElementType newElementType(String namespace) throws MetaStoreException {
        return new MemoryMetaStoreElementType(namespace);
    }

    @Override
    public IMetaStoreElement newElement() throws MetaStoreException {
        return new MemoryMetaStoreElement();
    }

    @Override
    public IMetaStoreElement newElement(IMetaStoreElementType elementType, String id, Object value) throws MetaStoreException {
        return new MemoryMetaStoreElement(elementType, id, value);
    }

    @Override
    public IMetaStoreAttribute newAttribute(String id, Object value) throws MetaStoreException {
        return new MemoryMetaStoreAttribute(id, value);
    }

    @Override
    public IMetaStoreElementOwner newElementOwner(String name, MetaStoreElementOwnerType ownerType) throws MetaStoreException {
        return new MemoryMetaStoreElementOwner(name, ownerType);
    }
}

