/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.jdbc.sql;

import com.kotelmems.platform.jdbc.sql.SimpleMRUCache;
import com.kotelmems.platform.jdbc.sql.SqlPlan;

public class SqlPlanFactory {
    private static SqlPlanFactory instance = new SqlPlanFactory();
    private SimpleMRUCache planCache = new SimpleMRUCache(1024);

    public static SqlPlanFactory getInstance() {
        return instance;
    }

    public SqlPlan getPlanCache(String nameSql) {
        SqlPlan sqlplan = (SqlPlan)this.planCache.get(nameSql);
        if (sqlplan == null) {
            sqlplan = new SqlPlan(nameSql);
            this.planCache.put(nameSql, sqlplan);
        }
        return sqlplan;
    }

    public static void main(String[] args) {
        String sql = "select userid,to_char(createTime,'YYYY-MM-DD HH24:mm:ss') from mypersion where namea2= :name and age>:age1 and age<:age2 and name = :name2";
        long start1 = System.currentTimeMillis();
        SqlPlan sqlplan = SqlPlanFactory.getInstance().getPlanCache(sql);
        System.out.println(sqlplan.getPlanSql());
        System.out.println(sqlplan.getNameList());
        long start2 = System.currentTimeMillis();
        System.out.println(start2 - start1);
        sqlplan = SqlPlanFactory.getInstance().getPlanCache(sql);
        System.out.println(sqlplan.getPlanSql());
        System.out.println(sqlplan.getNameList());
        System.out.println(System.currentTimeMillis() - start2);
    }
}

