/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.jdbc.sqlgenerator.metadata;

import com.kotelmems.platform.jdbc.sqlgenerator.metadata.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Table {
    private String tableName;
    private List<Column> columns;
    List<Column> primaryKeyColumns = null;

    public Table(String tableName, Column ... columns) {
        this(tableName, Arrays.asList(columns));
    }

    public Table(String tableName, List<Column> columns) {
        this.setTableName(tableName);
        this.setColumns(columns);
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
        this.primaryKeyColumns = null;
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Column> getPrimaryKeyColumns() {
        if (this.primaryKeyColumns == null) {
            this.primaryKeyColumns = this.getPrimaryKeyColumns0();
        }
        return this.primaryKeyColumns;
    }

    public int getPrimaryKeyCount() {
        return this.getPrimaryKeyColumns().size();
    }

    public Column getColumnBySqlName(String sqlName) {
        for (Column c : this.columns) {
            if (!c.getSqlName().equals(sqlName)) continue;
            return c;
        }
        return null;
    }

    public Column getColumnByPropertyName(String propertyName) {
        for (Column c : this.columns) {
            if (!c.getPropertyName().equals(propertyName)) continue;
            return c;
        }
        return null;
    }

    private List<Column> getPrimaryKeyColumns0() {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column c : this.getColumns()) {
            if (!c.isPrimaryKey()) continue;
            result.add(c);
        }
        return result;
    }

    public String toString() {
        return "tableName:" + this.getTableName() + " columns:" + this.getColumns();
    }
}

