/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.dao.hibernate;

import com.alibaba.fastjson.JSONObject;
import com.kotelmems.platform.dao.BaseDaoTableColumn;
import com.kotelmems.platform.dao.BaseDaoTableParm;
import com.kotelmems.platform.dao.EntityDao;
import com.kotelmems.platform.page.Page;
import com.kotelmems.platform.page.PageRequest;
import com.kotelmems.platform.page.SortInfo;
import com.kotelmems.platform.util.PageQueryUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class BaseHibernateDao<E, PK extends Serializable>
extends HibernateDaoSupport
implements EntityDao<E, PK> {
    protected Log log = LogFactory.getLog(this.getClass());

    public long queryForLong(String queryString) {
        return this.queryForLong(queryString, new Object[0]);
    }

    public long queryForLong(String queryString, Object value) {
        return this.queryForLong(queryString, new Object[]{value});
    }

    public long queryForLong(String queryString, Object[] values) {
        return DataAccessUtils.longResult((Collection)this.getHibernateTemplate().find(queryString, values));
    }

    public abstract Class<E> getEntityClass();

    protected void prepareObjectForInsert(E o) {
    }

    protected void prepareObjectForUpdate(E o) {
    }

    @Override
    public E getById(PK id) {
        return (E)this.getHibernateTemplate().get(this.getEntityClass(), id);
    }

    @Override
    public E insert(E entity) {
        this.prepareObjectForInsert(entity);
        Serializable id = this.getHibernateTemplate().save(entity);
        return this.getById(id);
    }

    public void delete(Object entity) {
        this.getHibernateTemplate().delete(entity);
    }

    public void deleteAllByParameter(E parameter) {
        List list;
        if (parameter != null && (list = this.findAllByParam(parameter)).size() > 0) {
            this.getHibernateTemplate().deleteAll((Collection)list);
        }
    }

    private void checkThowInParmException(Object[] inParm) {
        if (inParm == null || inParm.length == 0) {
            throw new NullPointerException("in\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7a7a\u96c6\u5408\uff01");
        }
    }

    public int updateByMapParm(final Map<String, Object> mapVal, final Map<String, Object> mapParm, final Map<String, Object[]> inmap) {
        StringBuffer sb = new StringBuffer(" UPDATE ").append(this.getEntityClass().getSimpleName());
        sb.append(" s ");
        Iterator<Map.Entry<String, Object>> iterator = mapVal == null ? null : mapVal.entrySet().iterator();
        int count = 0;
        while (iterator != null && iterator.hasNext()) {
            if (count > 0) {
                sb.append(", s.");
            } else {
                sb.append(" SET s.");
            }
            Map.Entry<String, Object> entry = iterator.next();
            sb.append(entry.getKey());
            sb.append(" = :");
            sb.append(entry.getKey());
            ++count;
        }
        sb.append(" WHERE 1=1 ");
        Iterator<Map.Entry<String, Object>> iteratorParm = mapParm == null ? null : mapParm.entrySet().iterator();
        while (iteratorParm != null && iteratorParm.hasNext()) {
            Map.Entry<String, Object> entry = iteratorParm.next();
            sb.append(" AND s.");
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NULL ");
                continue;
            }
            sb.append(" = :p_");
            sb.append(entry.getKey());
        }
        Iterator<Map.Entry<String, Object[]>> iteratorInmap = inmap == null ? null : inmap.entrySet().iterator();
        while (iteratorInmap != null && iteratorInmap.hasNext()) {
            Map.Entry<String, Object[]> entry = iteratorInmap.next();
            this.checkThowInParmException(entry.getValue());
            sb.append(" AND s.");
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
        }
        if (count == 0) {
            return 0;
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                Iterator iterator = mapVal == null ? null : mapVal.entrySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator iteratorParm = mapParm == null ? null : mapParm.entrySet().iterator();
                while (iteratorParm != null && iteratorParm.hasNext()) {
                    Map.Entry entry = iteratorParm.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter("p_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator iteratorInmap = inmap == null ? null : inmap.entrySet().iterator();
                while (iteratorInmap != null && iteratorInmap.hasNext()) {
                    Map.Entry entry = iteratorInmap.next();
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                return query.executeUpdate();
            }
        });
    }

    public List<E> findAllByMapParm(final Map<String, Object> map, final Map<String, Object[]> inmap) {
        String sortColumns;
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        Iterator<Map.Entry<String, Object>> iterator = map == null ? null : map.entrySet().iterator();
        int count = 0;
        while (iterator != null && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (inmapiterator != null && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            this.checkThowInParmException(entry.getValue());
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        if (count == 0) {
            return new ArrayList();
        }
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY " + sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                Iterator iterator = map == null ? null : map.entrySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (inmapiterator != null && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                return query.list();
            }
        });
    }

    public List findAllByMapNotOrParm(final Map<String, Object> map, final Map<String, Object> notMap, final Map<String, Object[]> inmap, final Map<String, Object[]> notInmap, final Map<String, Object> orMap, final Map<String, Object> orNotMap, final Map<String, Object[]> orInmap, final Map<String, Object[]> orNotInmap, final String columns) {
        String sortColumns;
        StringBuffer sb = new StringBuffer(200);
        int columnCount = 0;
        if (!BaseHibernateDao.isEmpty(columns)) {
            sb.append(" SELECT ");
            String[] arry = columns.split(",");
            columnCount = arry.length;
            int i = 0;
            while (i < columnCount) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(arry[i]);
                sb.append(" AS ");
                sb.append(arry[i]);
                ++i;
            }
        }
        final int findColumnCount = columnCount;
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        Iterator<Map.Entry<String, Object>> iterator = map == null ? null : map.entrySet().iterator();
        int count = 0;
        while (iterator != null && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object>> notMapiterator = notMap == null ? null : notMap.entrySet().iterator();
        while (notMapiterator != null && notMapiterator.hasNext()) {
            Map.Entry<String, Object> entry = notMapiterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NOT NULL ");
            } else {
                sb.append(" <> :not_");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (inmapiterator != null && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            this.checkThowInParmException(entry.getValue());
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> notInmapiterator = notInmap == null ? null : notInmap.entrySet().iterator();
        while (notInmapiterator != null && notInmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = notInmapiterator.next();
            this.checkThowInParmException(entry.getValue());
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" NOT IN (:noti_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        int orcount = 0;
        Iterator<Map.Entry<String, Object>> orMapiterator = orMap == null ? null : orMap.entrySet().iterator();
        while (orMapiterator != null && orMapiterator.hasNext()) {
            Map.Entry<String, Object> entry = orMapiterator.next();
            if (count > 0 && orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :or_");
                sb.append(entry.getKey());
            }
            ++orcount;
        }
        Iterator<Map.Entry<String, Object>> orNotMapiterator = orNotMap == null ? null : orNotMap.entrySet().iterator();
        while (orNotMapiterator != null && orNotMapiterator.hasNext()) {
            Map.Entry<String, Object> entry = orNotMapiterator.next();
            if (count > 0 && orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NOT NULL ");
            } else {
                sb.append(" <> :orNot_");
                sb.append(entry.getKey());
            }
            ++orcount;
        }
        Iterator<Map.Entry<String, Object[]>> orInmapiterator = orInmap == null ? null : orInmap.entrySet().iterator();
        while (orInmapiterator != null && orInmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = orInmapiterator.next();
            if (entry.getValue() == null || entry.getValue().length <= 0) continue;
            if (count > 0 && orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:or_i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++orcount;
        }
        Iterator<Map.Entry<String, Object[]>> orNotInmapiterator = orNotInmap == null ? null : orNotInmap.entrySet().iterator();
        while (orNotInmapiterator != null && orNotInmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = orNotInmapiterator.next();
            if (entry.getValue() == null || entry.getValue().length <= 0) continue;
            if (count > 0 && orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            sb.append(" NOT IN (:or_noti_");
            sb.append(entry.getKey());
            sb.append(")");
            ++orcount;
        }
        if (count > 0 && orcount > 0) {
            sb.append(" ) ");
        }
        if (count + orcount == 0) {
            return new ArrayList();
        }
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY " + sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                Iterator iterator = map == null ? null : map.entrySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator notMapiterator = notMap == null ? null : notMap.entrySet().iterator();
                while (notMapiterator != null && notMapiterator.hasNext()) {
                    Map.Entry entry = notMapiterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter("not_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (inmapiterator != null && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator notInmapiterator = notInmap == null ? null : notInmap.entrySet().iterator();
                while (notInmapiterator != null && notInmapiterator.hasNext()) {
                    Map.Entry entry = notInmapiterator.next();
                    query.setParameterList("noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator oriterator = orMap == null ? null : orMap.entrySet().iterator();
                while (oriterator != null && oriterator.hasNext()) {
                    Map.Entry entry = oriterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter("or_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator orNotMapiterator = orNotMap == null ? null : orNotMap.entrySet().iterator();
                while (orNotMapiterator != null && orNotMapiterator.hasNext()) {
                    Map.Entry entry = orNotMapiterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter("orNot_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator orinmapiterator = orInmap == null ? null : orInmap.entrySet().iterator();
                while (orinmapiterator != null && orinmapiterator.hasNext()) {
                    Map.Entry entry = orinmapiterator.next();
                    if (entry.getValue() == null || ((Object[])entry.getValue()).length <= 0) continue;
                    query.setParameterList("or_i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator orNotInmapiterator = orNotInmap == null ? null : orNotInmap.entrySet().iterator();
                while (orNotInmapiterator != null && orNotInmapiterator.hasNext()) {
                    Map.Entry entry = orNotInmapiterator.next();
                    if (entry.getValue() == null || ((Object[])entry.getValue()).length <= 0) continue;
                    query.setParameterList("or_noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                if (!BaseHibernateDao.isEmpty(columns) && findColumnCount != 1) {
                    query.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
                }
                return query.list();
            }
        });
    }

    public List findAllByMapOrParm(Map<String, Object> map, Map<String, Object[]> inmap, Map<String, Object[]> notInmap, Map<String, Object> orMap, Map<String, Object[]> orInmap, Map<String, Object[]> orNotInmap, String columns) {
        return this.findAllByMapNotOrParm(map, null, inmap, notInmap, orMap, null, orInmap, orNotInmap, columns);
    }

    public List<Map<String, Object>> findColumnsByMapParm(final Map<String, Object> map, final Map<String, Object[]> inmap, String columns) {
        String sortColumns;
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        int i = 0;
        while (i < arry.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
            ++i;
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        Iterator<Map.Entry<String, Object>> iterator = map == null ? null : map.entrySet().iterator();
        int count = 0;
        while (iterator != null && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (inmapiterator != null && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            this.checkThowInParmException(entry.getValue());
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        if (count == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY " + sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                Iterator iterator = map == null ? null : map.entrySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (inmapiterator != null && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                query.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public Integer findCountByMapParm(final Map<String, Object> map, final Map<String, Object[]> inmap) {
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        Iterator<Map.Entry<String, Object>> iterator = map == null ? null : map.entrySet().iterator();
        int count = 0;
        while (iterator != null && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (inmapiterator != null && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            this.checkThowInParmException(entry.getValue());
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                Iterator iterator = map == null ? null : map.entrySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (inmapiterator != null && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Object b = query.uniqueResult();
                if (b == null) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public List<E> findAllByFK(String key, final Object value) {
        String sortColumns;
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (value == null) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY ");
            sb.append(sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                if (value != null) {
                    query.setParameter("value", value);
                }
                return query.list();
            }
        });
    }

    public List<E> findAllNotByFK(String key, final Object value) {
        String sortColumns;
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (value == null) {
            sb.append(" IS NOT NULL ");
        } else {
            sb.append(" <> :value ");
        }
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY ");
            sb.append(sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                if (value != null) {
                    query.setParameter("value", value);
                }
                return query.list();
            }
        });
    }

    public List<Map<String, Object>> findColumnsByFK(String key, final Object value, String columns) {
        String sortColumns;
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        int i = 0;
        while (i < arry.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
            ++i;
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (value == null) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY ");
            sb.append(sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                if (value != null) {
                    query.setParameter("value", value);
                }
                query.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public List<Map<String, Object>> findColumnsNotByFK(String key, final Object value, String columns) {
        String sortColumns;
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        int i = 0;
        while (i < arry.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
            ++i;
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (value == null) {
            sb.append(" IS NOT NULL ");
        } else {
            sb.append(" <> :value ");
        }
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY ");
            sb.append(sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                if (value != null) {
                    query.setParameter("value", value);
                }
                query.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public Integer findCountByFK(String key, final Object value) {
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (value == null) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Object b;
                Query query = session.createQuery(hql);
                if (value != null) {
                    query.setParameter("value", value);
                }
                if ((b = query.uniqueResult()) == null) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public Integer findCountNotByFK(String key, final Object value) {
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (value == null) {
            sb.append(" IS NOT NULL ");
        } else {
            sb.append(" <> :value ");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Object b;
                Query query = session.createQuery(hql);
                if (value != null) {
                    query.setParameter("value", value);
                }
                if ((b = query.uniqueResult()) == null) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public Integer findCountInArry(String key, final Object[] value) {
        this.checkThowInParmException(value);
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" IN (:value) ");
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                Object b = query.uniqueResult();
                if (b == null) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public Integer findCountNotInArry(String key, final Object[] value) {
        this.checkThowInParmException(value);
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" NOT IN (:value) ");
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                Object b = query.uniqueResult();
                if (b == null) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public List<Map<String, Object>> findColumnsInArry(String key, final Object[] value, String columns) {
        String sortColumns;
        this.checkThowInParmException(value);
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        int i = 0;
        while (i < arry.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
            ++i;
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" IN (:value) ");
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY " + sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                query.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public List<Map<String, Object>> findColumnsNotInArry(String key, final Object[] value, String columns) {
        String sortColumns;
        this.checkThowInParmException(value);
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        int i = 0;
        while (i < arry.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
            ++i;
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" NOT IN (:value) ");
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY " + sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                query.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public List<E> findAllKeyInArry(String key, final Object[] value) {
        String sortColumns;
        this.checkThowInParmException(value);
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" IN (:value) ");
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY " + sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                return query.list();
            }
        });
    }

    public List<E> findAllKeyNotInArry(String key, final Object[] value) {
        String sortColumns;
        this.checkThowInParmException(value);
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" NOT IN (:value) ");
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sb.append(" ORDER BY " + sortColumns);
        }
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                return query.list();
            }
        });
    }

    public Page<E> findPageByMoreParam(PageRequest pageReq, Map<String, Object> mapParm, Map<String, Object[]> inmap, String searchColumns) {
        return this.findPageByMoresParam(pageReq, mapParm, null, inmap, null, null, searchColumns);
    }

    public Page findPageByMoresParam(final PageRequest pageReq, final Map<String, Object> mapParm, final Map<String, Object> notParm, final Map<String, Object[]> inmap, final Map<String, Object[]> notinmap, String columns, String searchColumns) {
        boolean isSeraceColumn;
        String sortColumns;
        StringBuffer sbInfo = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        StringBuffer sbTotal = new StringBuffer("SELECT COUNT(*) FROM ").append(this.getEntityClass().getSimpleName());
        StringBuffer sb = new StringBuffer(200);
        sb.append(" WHERE 1=1 ");
        int count = 0;
        Iterator<Map.Entry<String, Object>> iterator = mapParm == null ? null : mapParm.entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object>> notParmiterator = notParm == null ? null : notParm.entrySet().iterator();
        while (notParmiterator != null && notParmiterator.hasNext()) {
            Map.Entry<String, Object> entry = notParmiterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NOT NULL ");
            } else {
                sb.append(" <> :not_");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (inmapiterator != null && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            this.checkThowInParmException(entry.getValue());
            sb.append(" AND ");
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> notinmapiterator = notinmap == null ? null : notinmap.entrySet().iterator();
        while (notinmapiterator != null && notinmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = notinmapiterator.next();
            this.checkThowInParmException(entry.getValue());
            sb.append(" AND ");
            sb.append(entry.getKey());
            sb.append(" NOT IN (:noti_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        if (count == 0) {
            return new Page(pageReq, 0);
        }
        final boolean isSerach = StringUtils.isNotBlank((String)searchColumns);
        if (isSerach && StringUtils.isNotBlank((String)pageReq.getsSearch()) && StringUtils.isNotEmpty((String)pageReq.getsSearch())) {
            String[] searcColums = searchColumns.split(",");
            sb.append(" AND (");
            int i = 0;
            while (i < searcColums.length) {
                if (i != 0) {
                    sb.append(" OR ");
                }
                sb.append(searcColums[i]);
                sb.append(" LIKE :s_search ");
                ++i;
            }
            sb.append(")");
        }
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(this.getDefaultSortColumn())) {
            sb.append(" ORDER BY " + sortColumns);
        }
        StringBuffer sbcolumns = new StringBuffer(0);
        boolean bl = isSeraceColumn = !BaseHibernateDao.isEmpty(columns);
        if (isSeraceColumn) {
            sbcolumns.append("SELECT ");
            String[] arry = columns.split(",");
            int i = 0;
            while (i < arry.length) {
                if (i != 0) {
                    sbcolumns.append(", ");
                }
                sbcolumns.append(arry[i]);
                sbcolumns.append(" AS ");
                sbcolumns.append(arry[i]);
                ++i;
            }
        }
        final String hql = String.valueOf(isSeraceColumn ? sbcolumns.toString() : "") + sbInfo.toString() + sb.toString();
        final String totalHql = String.valueOf(sbTotal.toString()) + sb.toString();
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                Query totalQuery = session.createQuery(totalHql);
                if (isSeraceColumn) {
                    query.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
                }
                Iterator iterator = mapParm == null ? null : mapParm.entrySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                    totalQuery.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator notParmiterator = notParm == null ? null : notParm.entrySet().iterator();
                while (notParmiterator != null && notParmiterator.hasNext()) {
                    Map.Entry entry = notParmiterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter("not_" + (String)entry.getKey(), entry.getValue());
                    totalQuery.setParameter("not_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (inmapiterator != null && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                    totalQuery.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator notinmapiterator = notinmap == null ? null : notinmap.entrySet().iterator();
                while (notinmapiterator != null && notinmapiterator.hasNext()) {
                    Map.Entry entry = notinmapiterator.next();
                    query.setParameterList("noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                    totalQuery.setParameterList("noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                if (isSerach && StringUtils.isNotBlank((String)pageReq.getsSearch()) && StringUtils.isNotEmpty((String)pageReq.getsSearch())) {
                    query.setParameter("s_search", (Object)("%" + pageReq.getsSearch() + "%"));
                    totalQuery.setParameter("s_search", (Object)("%" + pageReq.getsSearch() + "%"));
                }
                return PageQueryUtils.executeQueryForPage((PageRequest)pageReq, (Query)query, (Query)totalQuery);
            }
        });
    }

    public int deleteAllKeyInArry(String key, final Object[] value) {
        this.checkThowInParmException(value);
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" IN (:value) ");
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllKeyNotInArry(String key, final Object[] value) {
        this.checkThowInParmException(value);
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" NOT IN (:value) ");
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllByMapFK(final Map<String, Object> map) {
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE 1=1 ");
        int count = 0;
        Iterator<Map.Entry<String, Object>> iterator = map == null ? null : map.entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                Iterator iterator = map == null ? null : map.entrySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllNotByMapFK(final Map<String, Object> notmap) {
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE 1=1 ");
        int count = 0;
        Iterator<Map.Entry<String, Object>> iterator = notmap == null ? null : notmap.entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (entry.getValue() == null) {
                sb.append(" IS NOT NULL ");
            } else {
                sb.append(" <> :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                Iterator iterator = notmap == null ? null : notmap.entrySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() == null) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllByKey(String key, final Object value) {
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (value == null) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                if (value != null) {
                    query.setParameter("value", value);
                }
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllNotByKey(String key, final Object value) {
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (value == null) {
            sb.append(" IS NOT NULL ");
        } else {
            sb.append(" <> :value ");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(hql);
                if (value != null) {
                    query.setParameter("value", value);
                }
                return query.executeUpdate();
            }
        });
    }

    public void deleteById(PK id) {
        E entity = this.getById(id);
        if (entity == null) {
            throw new ObjectRetrievalFailureException(this.getEntityClass(), id);
        }
        this.getHibernateTemplate().delete(entity);
    }

    @Override
    public void update(E entity) {
        this.prepareObjectForUpdate(entity);
        this.getHibernateTemplate().update(entity);
    }

    @Override
    public Page<E> findPage(PageRequest pageRequest, Object parameters) {
        this.log.info((Object)"---------------dao-------------\n");
        String sortColumns = BaseHibernateDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
        List sortList = new ArrayList();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            sortList = SortInfo.parseSortColumns((String)sortColumns);
        }
        DetachedCriteria totalCrit = DetachedCriteria.forClass(this.getEntityClass());
        totalCrit.setProjection(Projections.rowCount());
        totalCrit.add((Criterion)Example.create((Object)parameters).ignoreCase());
        List totalList = this.getHibernateTemplate().findByCriteria(totalCrit);
        int total = Integer.parseInt(totalList.get(0).toString());
        List list = new ArrayList();
        if (total > 0) {
            final DetachedCriteria listCrit = DetachedCriteria.forClass(this.getEntityClass());
            listCrit.add((Criterion)Example.create((Object)parameters));
            for (SortInfo sortInfo : sortList) {
                if (sortInfo.getSortOrder().equals("desc")) {
                    listCrit.addOrder(Order.desc((String)sortInfo.getColumnName()));
                    continue;
                }
                listCrit.addOrder(Order.asc((String)sortInfo.getColumnName()));
            }
            final PageRequest pageRequestTmp = pageRequest;
            list = (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Criteria criteria = listCrit.getExecutableCriteria(session);
                    criteria.setFirstResult(pageRequestTmp.getFirstResult());
                    criteria.setMaxResults(pageRequestTmp.getPageSize());
                    return criteria.list();
                }
            });
        }
        Page page = new Page(pageRequest, total);
        page.setResult(list);
        return page;
    }

    public void saveOrUpdate(E entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    public int saveAll(Collection<E> entities) {
        return this.saveOrUpdateAll(entities);
    }

    public int saveOrUpdateAll(final Collection<E> entities) {
        if (entities != null && entities.size() > 0) {
            if (entities.size() == 1) {
                this.getHibernateTemplate().saveOrUpdateAll(entities);
                return entities.size();
            }
            Class<E> clazz = this.getEntityClass();
            BaseDaoTableParm parm = new BaseDaoTableParm(clazz);
            StringBuffer sb = new StringBuffer(2000);
            sb.append("INSERT INTO ");
            sb.append(parm.getTableName());
            sb.append("(");
            final List<String> entrycolumns = parm.getEntrycolumns();
            List<String> sqlColumns = parm.getSqlColumns();
            StringBuffer upsb = new StringBuffer(200);
            int i = 0;
            while (i < sqlColumns.size()) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(sqlColumns.get(i));
                if (!parm.getSqlIdField().equals(sqlColumns.get(i))) {
                    if (upsb.length() != 0) {
                        upsb.append(", ");
                    }
                    upsb.append(sqlColumns.get(i));
                    upsb.append("=VALUES(");
                    upsb.append(sqlColumns.get(i));
                    upsb.append(")");
                }
                ++i;
            }
            sb.append(") VALUES ");
            Iterator<E> it = entities.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                E obj = it.next();
                JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                if (eObj == null) continue;
                if (i2 != 0) {
                    sb.append(", ");
                }
                sb.append("(");
                int j = 0;
                while (j < entrycolumns.size()) {
                    Object value;
                    if (j != 0) {
                        sb.append(", ");
                    }
                    if ((value = eObj.get((Object)entrycolumns.get(j))) == null) {
                        if (parm.isGeneratorUuid() && parm.getEntryIdField().equals(entrycolumns.get(j))) {
                            sb.append("UUID()");
                        } else {
                            sb.append("NULL");
                        }
                    } else {
                        sb.append("?");
                    }
                    ++j;
                }
                sb.append(")");
                ++i2;
            }
            sb.append(" ON DUPLICATE KEY UPDATE ");
            sb.append(upsb);
            final String sql = sb.toString();
            return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    SQLQuery query = session.createSQLQuery(sql);
                    int count = 0;
                    for (Object obj : entities) {
                        JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                        if (eObj == null) continue;
                        int j = 0;
                        while (j < entrycolumns.size()) {
                            Object value = eObj.get(entrycolumns.get(j));
                            if (value != null) {
                                query.setParameter(count, value);
                                ++count;
                            }
                            ++j;
                        }
                    }
                    return query.executeUpdate();
                }
            });
        }
        return 0;
    }

    public int saveOrUpdateColumns(final Collection<E> entities, String updateColumns) {
        if (StringUtils.isBlank((String)updateColumns)) {
            throw new NullPointerException("\u66f4\u65b0\u5217\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (entities != null && entities.size() > 0) {
            Class<E> clazz = this.getEntityClass();
            BaseDaoTableParm parm = new BaseDaoTableParm(clazz);
            StringBuffer sb = new StringBuffer(2000);
            sb.append("INSERT INTO ");
            sb.append(parm.getTableName());
            sb.append("(");
            final List<String> entrycolumns = parm.getEntrycolumns();
            List<String> sqlColumns = parm.getSqlColumns();
            StringBuffer upsb = new StringBuffer(200);
            String[] updateColumn = updateColumns.trim().split(",");
            int i = 0;
            while (i < sqlColumns.size()) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(sqlColumns.get(i));
                ++i;
            }
            Map<String, BaseDaoTableColumn> columnMap = parm.getColumns();
            int i2 = 0;
            while (i2 < updateColumn.length) {
                if (StringUtils.isNotBlank((String)updateColumn[i2]) && !parm.getEntryIdField().equals(updateColumn[i2])) {
                    if (!columnMap.containsKey(updateColumn[i2])) {
                        this.log.error((Object)("\u5b9e\u4f53\u4e2d\u914d\u7f6e\u4e2d\u672a\u53d1\u73b0\u6307\u5b9a\u5217" + updateColumn[i2]));
                    } else {
                        String sqlField = columnMap.get(updateColumn[i2]).getSqlField();
                        if (upsb.length() != 0) {
                            upsb.append(", ");
                        }
                        upsb.append(sqlField);
                        upsb.append("=VALUES(");
                        upsb.append(sqlField);
                        upsb.append(")");
                    }
                }
                ++i2;
            }
            sb.append(") VALUES ");
            Iterator<E> it = entities.iterator();
            int i3 = 0;
            while (it.hasNext()) {
                E obj = it.next();
                JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                if (eObj == null) continue;
                if (i3 != 0) {
                    sb.append(", ");
                }
                sb.append("(");
                int j = 0;
                while (j < entrycolumns.size()) {
                    Object value;
                    if (j != 0) {
                        sb.append(", ");
                    }
                    if ((value = eObj.get((Object)entrycolumns.get(j))) == null) {
                        if (parm.isGeneratorUuid() && parm.getEntryIdField().equals(entrycolumns.get(j))) {
                            sb.append("UUID()");
                        } else {
                            sb.append("NULL");
                        }
                    } else {
                        sb.append("?");
                    }
                    ++j;
                }
                sb.append(")");
                ++i3;
            }
            sb.append(" ON DUPLICATE KEY UPDATE ");
            sb.append(upsb);
            final String sql = sb.toString();
            return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    SQLQuery query = session.createSQLQuery(sql);
                    int count = 0;
                    for (Object obj : entities) {
                        JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                        if (eObj == null) continue;
                        int j = 0;
                        while (j < entrycolumns.size()) {
                            Object value = eObj.get(entrycolumns.get(j));
                            if (value != null) {
                                query.setParameter(count, value);
                                ++count;
                            }
                            ++j;
                        }
                    }
                    return query.executeUpdate();
                }
            });
        }
        return 0;
    }

    public int deleteAll(final Collection<E> entities) {
        if (entities != null && entities.size() > 0) {
            if (entities.size() == 1) {
                this.getHibernateTemplate().deleteAll(entities);
                return entities.size();
            }
            Class<E> clazz = this.getEntityClass();
            final BaseDaoTableParm parm = new BaseDaoTableParm(clazz);
            StringBuffer sb = new StringBuffer(2000);
            sb.append("DELETE FROM ");
            sb.append(parm.getTableName());
            sb.append(" WHERE ");
            sb.append(parm.getSqlIdField());
            sb.append(" IN (:ids)");
            final String sql = sb.toString();
            return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    SQLQuery query = session.createSQLQuery(sql);
                    Iterator list = entities.iterator();
                    ArrayList<String> ids = new ArrayList<String>();
                    while (list.hasNext()) {
                        Object obj = list.next();
                        JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                        String id = (String)eObj.get((Object)parm.getEntryIdField());
                        ids.add(id);
                    }
                    query.setParameterList("ids", ids);
                    return query.executeUpdate();
                }
            });
        }
        return 0;
    }

    public void refresh(Object entity) {
        this.getHibernateTemplate().refresh(entity);
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }

    public void evict(Object entity) {
        this.getHibernateTemplate().evict(entity);
    }

    public E findFirst(E entity) {
        List list = this.getHibernateTemplate().findByExample(entity, 0, 1);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<E> findAll() {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                List list = query.list();
                return list;
            }
        });
    }

    public Page findAll(PageRequest pageRequest) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        String string = sortColumns = BaseHibernateDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        final PageRequest finalPageRequest = pageRequest;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                Query countQuery = session.createQuery(countQueryString);
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    public Page findPageAllByParam(PageRequest pageRequest, Object parameters) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        this.initQueryPrama(parameters, queryStringBuff, pageRequest);
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        String string = sortColumns = BaseHibernateDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        System.out.println("---------queryString:          " + queryString);
        final PageRequest finalPageRequest = pageRequest;
        final Object finalparameters = parameters;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                BaseHibernateDao.this.initSearchProperties(query, finalPageRequest, finalparameters);
                Query countQuery = session.createQuery(countQueryString);
                BaseHibernateDao.this.initSearchProperties(countQuery, finalPageRequest, finalparameters);
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    private void initSearchProperties(Query querySearch, PageRequest finalPageRequest, Object parameters) {
        if (parameters != null) {
            JSONObject obj = this.covertJsonFromObject(parameters);
            Set objSet = obj.keySet();
            int count = 0;
            for (String key : objSet) {
                String value = obj.getString(key);
                if (!StringUtils.isNotEmpty((String)value) || !StringUtils.isNotBlank((String)value) || "null".equals(value)) continue;
                querySearch.setParameter(count, (Object)value);
                System.out.println("kcolumnStr" + key + "    count:" + count + "      value:" + value);
                ++count;
            }
            if (finalPageRequest != null && StringUtils.isNotBlank((String)finalPageRequest.getsSearch()) && StringUtils.isNotEmpty((String)finalPageRequest.getsSearch())) {
                for (String columnStr : objSet) {
                    if (columnStr.indexOf("Date") != -1 || columnStr.indexOf("date") != -1 || columnStr.indexOf("Time") != -1 || columnStr.indexOf("Type") != -1) continue;
                    System.out.println("columnStr:   " + columnStr + " count:" + count + "    searCh:" + finalPageRequest.getsSearch());
                    querySearch.setParameter(count, (Object)("%" + finalPageRequest.getsSearch() + "%"));
                    ++count;
                }
            }
        }
    }

    public Page findPageAllByInProperty(PageRequest pageRequest, Map parametersIn) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final List ls = this.initQueryPramaIn(parametersIn, queryStringBuff);
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        String string = sortColumns = BaseHibernateDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        final PageRequest finalPageRequest = pageRequest;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                if (ls != null && ls.size() > 0) {
                    query.setParameterList("list", (Collection)ls);
                }
                Query countQuery = session.createQuery(countQueryString);
                if (ls != null && ls.size() > 0) {
                    countQuery.setParameterList("list", (Collection)ls);
                }
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    public List findPageAllNoPageByInProperty(Map parametersIn) {
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final List ls = this.initQueryPramaIn(parametersIn, queryStringBuff);
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                if (ls != null && ls.size() > 0) {
                    query.setParameterList("list", (Collection)ls);
                }
                return query.list();
            }
        });
    }

    public List findAllByParam(Object parameters) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        this.initQueryPrama(parameters, queryStringBuff, null);
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        final Object finalparameters = parameters;
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                BaseHibernateDao.this.initSearchProperties(query, null, finalparameters);
                List list = query.list();
                return list;
            }
        });
    }

    public List findAllByParamLike(Object parameters) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final String param = this.initQueryPramaLike(parameters, queryStringBuff);
        String string = sortColumns = BaseHibernateDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                query.setString("param", String.valueOf(param) + "%");
                return query.list();
            }
        });
    }

    public Page<?> pageQuery(String hql, PageRequest pageRequest, Object parameters) {
        String countHql = PageQueryUtils.createCountSql((String)hql);
        return this.pageQuery(hql, countHql, pageRequest, parameters);
    }

    public Page<?> pageQuery(String hql, String countHql, PageRequest pageRequest, Object parameters) {
        return PageQueryUtils.pageQuery((HibernateTemplate)this.getHibernateTemplate(), (String)hql, (String)countHql, (PageRequest)pageRequest, (Object)parameters);
    }

    private static boolean isEmpty(Object id) {
        if (id == null) {
            return true;
        }
        if (id instanceof String) {
            return StringUtils.isEmpty((String)((String)id));
        }
        return false;
    }

    private void initQueryPrama(Object parameters, StringBuffer queryStringBuff, PageRequest pageRequest) {
        if (parameters == null && pageRequest == null) {
            return;
        }
        if (parameters == null && StringUtils.isEmpty((String)pageRequest.getsSearch()) && StringUtils.isBlank((String)pageRequest.getsSearch())) {
            return;
        }
        JSONObject obj = null;
        ArrayList<String> ls = new ArrayList<String>();
        if (parameters != null) {
            obj = this.covertJsonFromObject(parameters);
            for (String key : obj.keySet()) {
                String value = obj.getString(key);
                if (!StringUtils.isNotEmpty((String)value) || !StringUtils.isNotBlank((String)value) || "null".equals(value)) continue;
                ls.add(key);
            }
        }
        if (ls.size() > 0) {
            queryStringBuff.append(" c where ");
            int j = 0;
            while (j < ls.size()) {
                queryStringBuff.append(" c." + ls.get(j) + "= ? ");
                if (j < ls.size() - 1) {
                    queryStringBuff.append(" and ");
                }
                ++j;
            }
        }
        if (pageRequest != null && StringUtils.isNotEmpty((String)pageRequest.getsSearch()) && StringUtils.isNotBlank((String)pageRequest.getsSearch())) {
            if (ls.size() == 0) {
                queryStringBuff.append(" c where ");
            } else {
                queryStringBuff.append(" and ");
            }
            queryStringBuff.append(this.constructionSearchQuery(obj));
        }
    }

    private String constructionSearchQuery(JSONObject obj) {
        StringBuffer sbufferSearch = new StringBuffer();
        Set objset = obj.keySet();
        ArrayList<String> lsobj = new ArrayList<String>();
        if (objset != null && objset.size() > 0) {
            for (Object object : objset) {
                String key = (String)object;
                if (key.indexOf("Date") != -1 || key.indexOf("date") != -1 || key.indexOf("Time") != -1 || key.indexOf("Type") != -1) continue;
                lsobj.add(key);
            }
            sbufferSearch.append("(");
            int i = 0;
            while (i < lsobj.size()) {
                if (i == lsobj.size() - 1) {
                    sbufferSearch.append("c." + (String)lsobj.get(i) + " like ? )");
                } else {
                    sbufferSearch.append("c." + (String)lsobj.get(i) + " like ? or ");
                }
                ++i;
            }
        }
        return sbufferSearch.toString();
    }

    private List initQueryPramaIn(Map parametersIn, StringBuffer queryStringBuff) {
        List valueLs = new ArrayList();
        if (parametersIn != null) {
            Iterator iterator = parametersIn.entrySet().iterator();
            String keyStr = "";
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                keyStr = (String)entry.getKey();
                valueLs = (List)entry.getValue();
            }
            if (valueLs != null && valueLs.size() > 0) {
                queryStringBuff.append(" c where ");
                queryStringBuff.append(" c." + keyStr + " in (:list) ");
            }
        }
        return valueLs;
    }

    private List initQueryPramaNotIn(Map parametersIn, StringBuffer queryStringBuff) {
        List valueLs = new ArrayList();
        if (parametersIn != null) {
            Iterator iterator = parametersIn.entrySet().iterator();
            String keyStr = "";
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                keyStr = (String)entry.getKey();
                valueLs = (List)entry.getValue();
            }
            if (valueLs != null && valueLs.size() > 0) {
                queryStringBuff.append(" c where ");
                queryStringBuff.append(" c." + keyStr + " not in (:list) ");
            }
        }
        return valueLs;
    }

    private String initQueryPramaLike(Object parameters, StringBuffer queryStringBuff) {
        String likeValue = "";
        if (parameters != null) {
            JSONObject obj = this.covertJsonFromObject(parameters);
            Iterator it = obj.keySet().iterator();
            ArrayList<String> ls = new ArrayList<String>();
            while (it.hasNext()) {
                String value;
                String key = (String)it.next();
                String value1 = obj.getString(key);
                if (!(value1 instanceof String) || !StringUtils.isNotEmpty((String)(value = value1)) || !StringUtils.isNotBlank((String)value) || "null".equals(value)) continue;
                ls.add(key);
                likeValue = value;
                break;
            }
            if (ls.size() > 0) {
                queryStringBuff.append(" c where ");
                int j = 0;
                while (j < ls.size()) {
                    queryStringBuff.append(" c." + (String)ls.get(j) + " like:param");
                    if (j < ls.size() - 1) {
                        queryStringBuff.append(" and ");
                    }
                    ++j;
                }
            }
        }
        return likeValue;
    }

    private JSONObject covertJsonFromObject(Object parameters) {
        JSONObject obj = (JSONObject)JSONObject.toJSON((Object)parameters);
        return obj;
    }
}

