/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.enumerable.loader;

import com.kotelmems.platform.enumerable.EnumItem;
import com.kotelmems.platform.enumerable.PlainEnumItem;
import com.kotelmems.platform.enumerable.loader.EnumLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.Resource;

public class XmlEnumLoader
implements EnumLoader {
    private Resource[] resources;

    public void setResources(Resource ... resources) {
        this.resources = resources;
    }

    public XmlEnumLoader() {
    }

    public XmlEnumLoader(Resource ... resources) {
        this.resources = resources;
    }

    @Override
    public Map<String, List<EnumItem>> load() {
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        Resource[] resourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            result.putAll(this.parseXml(resource));
            ++n2;
        }
        return result;
    }

    private Map<String, List<EnumItem>> parseXml(Resource resource) {
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(resource.getInputStream());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Element root = doc.getRootElement();
        List cblist = root.elements("enum");
        int i = 0;
        while (i < cblist.size()) {
            Element cbinfo = (Element)cblist.get(i);
            String type = cbinfo.attributeValue("type");
            ArrayList<PlainEnumItem> items = new ArrayList<PlainEnumItem>();
            List entrys = cbinfo.elements("entry");
            int j = 0;
            while (j < entrys.size()) {
                Element eninfo = (Element)entrys.get(j);
                String code = eninfo.attributeValue("code");
                String name = eninfo.attributeValue("name");
                String nameI18N = eninfo.attributeValue("nameI18N");
                PlainEnumItem item = new PlainEnumItem(type, code, name, nameI18N, j);
                items.add(item);
                ++j;
            }
            result.put(type, items);
            ++i;
        }
        return result;
    }
}

