/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.component.xml.impl;

import com.kotelmems.platform.component.xml.XmlManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XmlManagerImpl
implements XmlManager {
    private String encoding = "UTF-8";
    private boolean formatXml = true;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFormatXml(boolean formatXml) {
        this.formatXml = formatXml;
    }

    @Override
    public <T> T unpack(Class<T> clazz, Reader reader) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Object bean = unmarshaller.unmarshal(reader);
        return (T)bean;
    }

    @Override
    public <T> T unpack(Class<T> clazz, InputStream in) throws Exception {
        InputStreamReader reader = new InputStreamReader(in, this.encoding);
        return this.unpack(clazz, reader);
    }

    @Override
    public void pack(Object bean, Writer writer) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)this.formatXml);
        marshaller.marshal(bean, writer);
    }

    @Override
    public void pack(Object bean, OutputStream os) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)this.formatXml);
        OutputStreamWriter writer = new OutputStreamWriter(os, this.encoding);
        marshaller.marshal(bean, (Writer)writer);
    }
}

