/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.enumerable.loader;

import com.kotelmems.platform.enumerable.EnumItem;
import com.kotelmems.platform.enumerable.PlainEnumItem;
import com.kotelmems.platform.enumerable.loader.EnumLoader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBEnumLoader
implements EnumLoader {
    private static Log log = LogFactory.getLog(DBEnumLoader.class);
    private DataSource dataSource;
    private String tableName;
    private String typeColumnName;
    private String codeColumnName;
    private String nameColumnName;
    private String nameI18NColumnName;
    private String indexColumnName;
    private String nextTypeCode;

    public String getQuerySql() {
        return new StringBuffer("select ").append(this.typeColumnName).append(",").append(this.codeColumnName).append(",").append(this.nameColumnName).append(",").append(this.nameI18NColumnName).append(",").append(this.indexColumnName).append(",").append(this.nextTypeCode).append(" from ").append(this.tableName).append(" order by ").append(this.typeColumnName).append(",").append(this.indexColumnName).toString();
    }

    @Override
    public Map<String, List<EnumItem>> load() {
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(this.getQuerySql());
                log.debug((Object)("loaded " + rs.getMetaData().getColumnCount() + " enum items from db with sql:" + this.getQuerySql()));
                while (rs.next()) {
                    List<PlainEnumItem> ets;
                    PlainEnumItem item = new PlainEnumItem(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getInt(5), rs.getString(6));
                    if (!result.containsKey(item.getType())) {
                        ets = new ArrayList<PlainEnumItem>();
                        ets.add(item);
                        result.put(item.getType(), ets);
                        continue;
                    }
                    ets = (List)result.get(item.getType());
                    ets.add(item);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    rs.close();
                    stmt.close();
                    conn.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTypeColumnName(String typeColumnName) {
        this.typeColumnName = typeColumnName;
    }

    public void setCodeColumnName(String codeColumnName) {
        this.codeColumnName = codeColumnName;
    }

    public void setNameColumnName(String nameColumnName) {
        this.nameColumnName = nameColumnName;
    }

    public void setNameI18NColumnName(String nameI18NColumnName) {
        this.nameI18NColumnName = nameI18NColumnName;
    }

    public void setIndexColumnName(String indexColumnName) {
        this.indexColumnName = indexColumnName;
    }

    public void setNextTypeCode(String nextTypeCode) {
        this.nextTypeCode = nextTypeCode;
    }
}

