/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.xsqlbuilder;

import com.kotelmems.platform.xsqlbuilder.MapAndObject;
import com.kotelmems.platform.xsqlbuilder.ObjectUtils;
import com.kotelmems.platform.xsqlbuilder.SafeSqlProcesser;
import com.kotelmems.platform.xsqlbuilder.datamodifier.DataModifierUtils;
import com.kotelmems.platform.xsqlbuilder.safesql.DirectReturnSafeSqlProcesser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XsqlBuilder {
    protected String markKeyStartChar = "{";
    protected String markKeyEndChar = "}";
    protected String replaceKeyStartChar = "[";
    protected String replaceKeyEndChar = "]";
    static final Log logger = LogFactory.getLog(XsqlBuilder.class);
    private boolean isRemoveEmptyString = true;
    private SafeSqlProcesser safeSqlProcesser = DirectReturnSafeSqlProcesser.INSTANCE;

    public XsqlBuilder() {
    }

    public XsqlBuilder(boolean isRemoveEmptyStrings) {
        this.setRemoveEmptyString(isRemoveEmptyStrings);
    }

    public XsqlBuilder(SafeSqlProcesser safeSqlProcesser) {
        this.setSafeSqlProcesser(safeSqlProcesser);
    }

    public XsqlBuilder(boolean isRemoveEmptyStrings, SafeSqlProcesser safeSqlProcesser) {
        this.setRemoveEmptyString(isRemoveEmptyStrings);
        this.setSafeSqlProcesser(safeSqlProcesser);
    }

    public boolean isRemoveEmptyString() {
        return this.isRemoveEmptyString;
    }

    public void setRemoveEmptyString(boolean isRemoveEmptyStrings) {
        this.isRemoveEmptyString = isRemoveEmptyStrings;
    }

    public SafeSqlProcesser getSafeSqlProcesser() {
        return this.safeSqlProcesser;
    }

    public void setSafeSqlProcesser(SafeSqlProcesser safeSqlProcesser) {
        if (safeSqlProcesser == null) {
            throw new NullPointerException("'safeSqlProcesser' property must be not null");
        }
        this.safeSqlProcesser = safeSqlProcesser;
    }

    public String replaceKeyMaskWithString(String xsql, Map acceptedFilters, String str) {
        for (Object key : acceptedFilters.keySet()) {
            xsql = StringUtils.replace(xsql, String.valueOf(this.markKeyStartChar) + key + this.markKeyEndChar, str);
        }
        return xsql;
    }

    public String replaceKeyMaskWithKeyValue(String xsql, Map acceptedFilters) {
        for (Object key : acceptedFilters.keySet()) {
            xsql = StringUtils.replace(xsql, String.valueOf(this.markKeyStartChar) + key + this.markKeyEndChar, acceptedFilters.get(key).toString());
        }
        return xsql;
    }

    public XsqlFilterResult generateSql(String sourceXsql, Object filters) {
        XsqlFilterResult sfr = this.applyFilters(sourceXsql, filters);
        return new XsqlFilterResult(this.replaceKeyMaskWithString(sfr.getXsql(), sfr.getAcceptedFilters(), "?"), sfr.getAcceptedFilters());
    }

    public XsqlFilterResult generateSql(String sourceXsql, Map filters) {
        return this.generateSql(sourceXsql, (Object)filters);
    }

    public XsqlFilterResult generateSql(String sourceXsql, Map filtersMap, Object filtersBean) {
        return this.generateSql(sourceXsql, new MapAndObject(filtersMap, filtersBean));
    }

    public XsqlFilterResult generateHql(String sourceXsql, Object filters) {
        XsqlFilterResult sfr = this.applyFilters(sourceXsql, filters);
        String resultHql = sfr.getXsql();
        for (Object key : sfr.getAcceptedFilters().keySet()) {
            resultHql = StringUtils.replace(resultHql, String.valueOf(this.markKeyStartChar) + key + this.markKeyEndChar, ":" + key);
        }
        return new XsqlFilterResult(resultHql, sfr.getAcceptedFilters());
    }

    public XsqlFilterResult generateHql(String sourceXsql, Map filters) {
        return this.generateHql(sourceXsql, (Object)filters);
    }

    public XsqlFilterResult generateHql(String sourceXsql, Map filtersMap, Object filtersBean) {
        return this.generateHql(sourceXsql, new MapAndObject(filtersMap, filtersBean));
    }

    public XsqlFilterResult applyFilters(String xsql, Object filters) {
        if (xsql == null) {
            throw new IllegalArgumentException("'sqlplan' must be not null");
        }
        return this.applyFilters(new StringBuffer(xsql), filters);
    }

    public XsqlFilterResult applyFilters(String xsql, Map filters) {
        return this.applyFilters(xsql, (Object)filters);
    }

    public XsqlFilterResult applyFilters(String xsql, Map filtersMap, Object filtersBean) {
        return this.applyFilters(new StringBuffer(xsql), filtersMap, filtersBean);
    }

    private XsqlFilterResult applyFilters(StringBuffer xsql, Map filtersMap, Object filtersBean) {
        return this.applyFilters(xsql, (Object)new MapAndObject(filtersMap, filtersBean));
    }

    private XsqlFilterResult applyFilters(StringBuffer xsql, Object filters) {
        LinkedHashMap acceptedFilters = new LinkedHashMap();
        int i = 0;
        int end = 0;
        int start = xsql.indexOf("/~");
        while ((start = xsql.indexOf("/~", end)) >= 0) {
            end = xsql.indexOf("~/", start);
            KeyMetaDatas metadatas = this.getKeyMetaDatas(xsql, start, end);
            if (metadatas.markKeys.isEmpty() && metadatas.replaceKeys.isEmpty()) {
                throw new IllegalArgumentException("Not key found in segment=" + xsql.substring(start, end + 2));
            }
            if (this.isAcceptedAllKeys(filters, metadatas.markKeys) && this.isAcceptedAllKeys(filters, metadatas.replaceKeys)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The filter markKeys=" + metadatas.markKeys + " replaceKeys=" + metadatas.replaceKeys + " is accepted on segment=" + xsql.substring(start, end + 2)));
                }
                String segment = xsql.substring(start + 2, end);
                segment = this.mergeMarkKeysIntoAcceptedFilters(filters, acceptedFilters, metadatas, segment);
                segment = this.replaceReplaceKeysWithValues(filters, metadatas.replaceKeys, segment);
                xsql.replace(start, end + 2, segment);
                end = start + segment.length();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The filter markKeys=" + metadatas.markKeys + " replaceKeys=" + metadatas.replaceKeys + " is removed from the query on segment=" + xsql.substring(start, end + 2)));
                }
                xsql.replace(start, end + 2, "");
                end = start;
            }
            ++i;
        }
        return new XsqlFilterResult(xsql.toString(), acceptedFilters);
    }

    private String mergeMarkKeysIntoAcceptedFilters(Object filters, Map acceptedFilters, KeyMetaDatas metadatas, String segment) {
        int n = 0;
        while (n < metadatas.markKeys.size()) {
            String dataModifierExpression = (String)metadatas.markKeys.get(n);
            String key = DataModifierUtils.getModifyVariable(dataModifierExpression);
            Object value = DataModifierUtils.modify(dataModifierExpression, ObjectUtils.getProperty(filters, key));
            acceptedFilters.put(key, value);
            segment = StringUtils.replace(segment, String.valueOf(this.markKeyStartChar) + dataModifierExpression + this.markKeyEndChar, String.valueOf(this.markKeyStartChar) + key + this.markKeyEndChar);
            ++n;
        }
        return segment;
    }

    private String replaceReplaceKeysWithValues(Object filters, List replaceKeys, String segment) {
        int n = 0;
        while (n < replaceKeys.size()) {
            String dataModifierExpression = (String)replaceKeys.get(n);
            String key = DataModifierUtils.getModifyVariable(dataModifierExpression);
            String value = DataModifierUtils.modify(dataModifierExpression, ObjectUtils.getProperty(filters, key)).toString();
            value = this.safeSqlProcesser.process(value);
            segment = StringUtils.replace(segment, String.valueOf(this.replaceKeyStartChar) + dataModifierExpression + this.replaceKeyEndChar, value);
            ++n;
        }
        return segment;
    }

    private boolean isAcceptedAllKeys(Object filters, List keys) {
        int n = 0;
        while (n < keys.size()) {
            String dataModifierExpression = (String)keys.get(n);
            String key = DataModifierUtils.getModifyVariable(dataModifierExpression);
            Object value = ObjectUtils.getProperty(filters, key);
            if (!this.isValuePopulated(value, this.isRemoveEmptyString)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    KeyMetaDatas getKeyMetaDatas(StringBuffer xsql, int start, int end) {
        List markKeys = this.getKeys(xsql, start, end, this.markKeyStartChar, this.markKeyEndChar);
        List replaceKeys = this.getKeys(xsql, start, end, this.replaceKeyStartChar, this.replaceKeyEndChar);
        return new KeyMetaDatas(markKeys, replaceKeys);
    }

    private List getKeys(StringBuffer xsql, int start, int end, String keyPrifix, String keySuffix) {
        int keyStart;
        ArrayList<String> results = new ArrayList<String>();
        int keyEnd = keyStart = start;
        while ((keyStart = xsql.indexOf(keyPrifix, keyStart)) <= end && keyStart >= 0 && (keyEnd = xsql.indexOf(keySuffix, keyStart + 1)) <= end && keyEnd >= 0) {
            String key = xsql.substring(keyStart + 1, keyEnd);
            results.add(key);
            keyStart = keyEnd + 1;
        }
        return results;
    }

    protected boolean isValuePopulated(Object value, boolean isRemoveEmptyStrings) {
        if (value == null) {
            return false;
        }
        if (isRemoveEmptyStrings && value instanceof String) {
            return ((String)value).length() > 0;
        }
        return true;
    }

    class KeyMetaDatas {
        List markKeys;
        List replaceKeys;

        public KeyMetaDatas(List markKeys, List replaceKeys) {
            this.markKeys = markKeys;
            this.replaceKeys = replaceKeys;
        }
    }

    private static class StringUtils {
        private StringUtils() {
        }

        public static String replace(String inString, String oldPattern, String newPattern) {
            if (inString == null) {
                return null;
            }
            if (oldPattern == null || newPattern == null) {
                return inString;
            }
            StringBuffer sbuf = new StringBuffer();
            int pos = 0;
            int index = inString.indexOf(oldPattern);
            int patLen = oldPattern.length();
            while (index >= 0) {
                sbuf.append(inString.substring(pos, index));
                sbuf.append(newPattern);
                pos = index + patLen;
                index = inString.indexOf(oldPattern, pos);
            }
            sbuf.append(inString.substring(pos));
            return sbuf.toString();
        }
    }

    public static class XsqlFilterResult {
        private String xsql;
        private Map acceptedFilters;

        public XsqlFilterResult(String xsql, Map acceptedFilters) {
            this.setXsql(xsql);
            this.setAcceptedFilters(acceptedFilters);
        }

        public void setXsql(String xsql) {
            this.xsql = xsql;
        }

        public String getXsql() {
            return this.xsql;
        }

        public void setAcceptedFilters(Map acceptedFilters) {
            this.acceptedFilters = acceptedFilters;
        }

        public Map getAcceptedFilters() {
            return this.acceptedFilters;
        }
    }
}

