/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExchangeClient {
    public static Log log = LogFactory.getLog(ExchangeClient.class);
    private final String hostname;
    private final ExchangeVersion exchangeVersion;
    private final String domain;
    private final String username;
    private final String password;
    private final String subject;
    private final String recipientTo;
    private final List<String> recipientTos;
    private final List<String> recipientCc;
    private final List<String> recipientBcc;
    private final List<String> attachments;
    private final String message;

    private ExchangeClient(ExchangeClientBuilder builder) {
        this.hostname = builder.hostname;
        this.exchangeVersion = builder.exchangeVersion;
        this.domain = builder.domain;
        this.username = builder.username;
        this.password = builder.password;
        this.subject = builder.subject;
        this.recipientTo = builder.recipientTo;
        this.recipientTos = builder.recipientTos;
        this.recipientCc = builder.recipientCc;
        this.recipientBcc = builder.recipientBcc;
        this.attachments = builder.attachments;
        this.message = builder.message;
    }

    public boolean sendExchange() {
        EmailMessage emailMessage;
        ExchangeService exchangeService = new ExchangeService(this.exchangeVersion);
        WebCredentials exchangeCredentials = new WebCredentials(this.username, this.password, this.domain);
        exchangeService.setCredentials((ExchangeCredentials)exchangeCredentials);
        try {
            exchangeService.setUrl(new URI("https://" + this.hostname + "/ews/Exchange.asmx"));
        }
        catch (URISyntaxException ex) {
            log.info((Object)"An exception occured while creating the uri for exchange service.", (Throwable)ex);
            return false;
        }
        try {
            emailMessage = new EmailMessage(exchangeService);
            emailMessage.setSubject(this.subject);
            emailMessage.setBody(MessageBody.getMessageBodyFromText((String)this.message));
        }
        catch (Exception ex) {
            log.info((Object)"An exception occured while setting the email message.", (Throwable)ex);
            return false;
        }
        for (String recipient : this.recipientTos) {
            try {
                emailMessage.getToRecipients().add(recipient);
            }
            catch (ServiceLocalException ex) {
                log.info((Object)("An exception occured while sstting the Tos recipient(" + recipient + ")."), (Throwable)ex);
                return false;
            }
        }
        for (String recipient : this.recipientCc) {
            try {
                emailMessage.getCcRecipients().add(recipient);
            }
            catch (ServiceLocalException ex) {
                log.info((Object)("An exception occured while sstting the CC recipient(" + recipient + ")."), (Throwable)ex);
                return false;
            }
        }
        for (String recipient : this.recipientBcc) {
            try {
                emailMessage.getBccRecipients().add(recipient);
            }
            catch (ServiceLocalException ex) {
                log.info((Object)("An exception occured while sstting the BCC recipient(" + recipient + ")."), (Throwable)ex);
                return false;
            }
        }
        for (String attachmentPath : this.attachments) {
            try {
                emailMessage.getAttachments().addFileAttachment(attachmentPath);
            }
            catch (ServiceLocalException ex) {
                log.info((Object)"An exception occured while setting the attachment.", (Throwable)ex);
                return false;
            }
        }
        try {
            emailMessage.send();
            log.info((Object)"An email is send.");
        }
        catch (Exception ex) {
            log.info((Object)"An exception occured while sending an email.", (Throwable)ex);
            return false;
        }
        return true;
    }

    /* synthetic */ ExchangeClient(ExchangeClientBuilder exchangeClientBuilder, ExchangeClient exchangeClient) {
        this(exchangeClientBuilder);
    }

    public static class ExchangeClientBuilder {
        private String hostname = "";
        private ExchangeVersion exchangeVersion = ExchangeVersion.Exchange2010_SP1;
        private String domain;
        private String username = "";
        private String password = "";
        private String subject = "";
        private String recipientTo = "";
        private List<String> recipientTos = new ArrayList<String>(0);
        private List<String> recipientCc = new ArrayList<String>(0);
        private List<String> recipientBcc = new ArrayList<String>(0);
        private List<String> attachments = new ArrayList<String>(0);
        private String message = "";

        public ExchangeClientBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public ExchangeClientBuilder exchangeVersion(ExchangeVersion exchangeVersion) {
            this.exchangeVersion = exchangeVersion;
            return this;
        }

        public ExchangeClientBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public ExchangeClientBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ExchangeClientBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ExchangeClientBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public ExchangeClientBuilder recipientTo(String recipientTo) {
            this.recipientTo = recipientTo;
            return this;
        }

        public ExchangeClientBuilder recipientTos(String recipientTos, String ... recipientsTos) {
            ArrayList<String> recipients = new ArrayList<String>(1 + recipientsTos.length);
            recipients.add(recipientTos);
            recipients.addAll(Arrays.asList(recipientsTos));
            this.recipientTos = recipients;
            return this;
        }

        public ExchangeClientBuilder recipientTos(List<String> recipientTos) {
            this.recipientTos = recipientTos;
            return this;
        }

        public ExchangeClientBuilder recipientCc(String recipientCc, String ... recipientsCc) {
            ArrayList<String> recipients = new ArrayList<String>(1 + recipientsCc.length);
            recipients.add(recipientCc);
            recipients.addAll(Arrays.asList(recipientsCc));
            this.recipientCc = recipients;
            return this;
        }

        public ExchangeClientBuilder recipientCc(List<String> recipientCc) {
            this.recipientCc = recipientCc;
            return this;
        }

        public ExchangeClientBuilder recipientBcc(String recipientBcc, String ... recipientsBcc) {
            ArrayList<String> recipients = new ArrayList<String>(1 + recipientsBcc.length);
            recipients.add(recipientBcc);
            recipients.addAll(Arrays.asList(recipientsBcc));
            this.recipientBcc = recipients;
            return this;
        }

        public ExchangeClientBuilder recipientBcc(List<String> recipientBcc) {
            this.recipientBcc = recipientBcc;
            return this;
        }

        public ExchangeClientBuilder attachments(String attachment, String ... attachments) {
            ArrayList<String> attachmentsToUse = new ArrayList<String>(1 + attachments.length);
            attachmentsToUse.add(attachment);
            attachmentsToUse.addAll(Arrays.asList(attachments));
            this.attachments = attachmentsToUse;
            return this;
        }

        public ExchangeClientBuilder attachments(List<String> attachments) {
            this.attachments = attachments;
            return this;
        }

        public ExchangeClientBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ExchangeClient build() {
            return new ExchangeClient(this, null);
        }
    }
}

