/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.common;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import com.jumipm.onlinedocument.farm.wda.util.AppConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class CompressFile {
    public static void ZipFiles(File[] srcfile, File zipfile) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(zipfile));
            int i = 0;
            while (i < srcfile.length) {
                int len;
                FileInputStream in = new FileInputStream(srcfile[i]);
                out.putNextEntry(new ZipEntry(srcfile[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i;
            }
            out.close();
            System.out.println("\u538b\u7f29\u5b8c\u6210.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void unZipFiles(File zipfile, String descDir) {
        try {
            ZipFile zf = new ZipFile(zipfile, AppConfig.getString("config.zip.encode"));
            Enumeration entries = zf.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = null;
                OutputStream out = null;
                try {
                    try {
                        int len;
                        in = zf.getInputStream(entry);
                        out = new FileOutputStream(String.valueOf(descDir) + zipEntryName.replaceAll("\\\\", File.separator).replaceAll("/", File.separator));
                        byte[] buf1 = new byte[1024];
                        while ((len = in.read(buf1)) > 0) {
                            out.write(buf1, 0, len);
                        }
                    }
                    catch (Exception exception) {
                        if (in != null) {
                            in.close();
                        }
                        if (out == null) continue;
                        out.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                if (in != null) {
                    in.close();
                }
                if (out == null) continue;
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void unRarFile(String srcRarPath, String dstDirectoryPath) {
        block10: {
            File dstDiretory = new File(dstDirectoryPath);
            if (!dstDiretory.exists()) {
                dstDiretory.mkdirs();
            }
            Archive a = null;
            try {
                a = new Archive(new File(srcRarPath));
                if (a == null) break block10;
                FileHeader fh = a.nextFileHeader();
                while (fh != null) {
                    if (fh.isDirectory()) {
                        File fol = new File(String.valueOf(dstDirectoryPath) + File.separator + fh.getFileNameString());
                        fol.mkdirs();
                    } else {
                        File out = new File(String.valueOf(dstDirectoryPath) + File.separator + fh.getFileNameW().trim());
                        try {
                            if (!out.exists()) {
                                if (!out.getParentFile().exists()) {
                                    out.getParentFile().mkdirs();
                                }
                                out.createNewFile();
                            }
                            FileOutputStream os = new FileOutputStream(out);
                            a.extractFile(fh, (OutputStream)os);
                            os.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    fh = a.nextFileHeader();
                }
                a.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

