/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.service.impl;

import com.farm.wda.exception.ErrorTypeException;
import com.jumipm.onlinedocument.farm.wda.Beanfactory;
import com.jumipm.onlinedocument.farm.wda.service.FileKeyCoderInter;
import com.jumipm.onlinedocument.farm.wda.util.ConfUtils;
import com.jumipm.onlinedocument.farm.wda.util.Md5Utils;
import java.io.File;

public class FileKeyCoderImpl
implements FileKeyCoderInter {
    private static String name = "wda";

    @Override
    public String parseDir(String key) {
        String str = Md5Utils.MD5(key);
        String path = String.valueOf(name) + str.substring(0, 2);
        path = String.valueOf(path) + File.separator + name + str.substring(2, 4);
        path = String.valueOf(path) + File.separator + name + str.substring(4, 6);
        path = String.valueOf(path) + File.separator + name + str.substring(6, 8);
        path = String.valueOf(path) + File.separator + name + str.substring(8, 10);
        path = String.valueOf(path) + File.separator + name + str.substring(10);
        return path;
    }

    @Override
    public String parseRealPath(String key, String exname) throws ErrorTypeException {
        String path = String.valueOf(this.parseDir(key)) + File.separator + this.parseFileName(exname);
        if (Beanfactory.WEB_DIR != null && !Beanfactory.WEB_DIR.isEmpty()) {
            String paht = String.valueOf(Beanfactory.WEB_DIR) + File.separator + path;
            return paht;
        }
        return path;
    }

    @Override
    public File parseFile(String key, String exname) throws ErrorTypeException {
        File file = new File(this.parseRealPath(key, exname));
        file.getParentFile().mkdirs();
        return file;
    }

    @Override
    public String parseFileName(String exname) throws ErrorTypeException {
        String fileName = ConfUtils.getTargetTypes().get(exname);
        if (fileName == null) {
            throw new ErrorTypeException("\u6587\u4ef6\u7c7b\u578b\u672a\u88ab\u5b9a\u4e49:" + exname);
        }
        return fileName;
    }

    @Override
    public File parseLogFile(String key) {
        String path = String.valueOf(this.parseDir(key)) + File.separator + this.parseLogFileName();
        if (Beanfactory.WEB_DIR != null && !Beanfactory.WEB_DIR.isEmpty()) {
            path = String.valueOf(Beanfactory.WEB_DIR) + File.separator + path;
        }
        File file = new File(path);
        file.getParentFile().mkdirs();
        return file;
    }

    @Override
    public String parseLogFileName() {
        String fileName = "log" + File.separator + "file.log";
        return fileName;
    }

    @Override
    public String parseInfoFileName() {
        String fileName = "info.txt";
        return fileName;
    }

    @Override
    public File parseInfoFile(String key) {
        String path = String.valueOf(this.parseDir(key)) + File.separator + this.parseInfoFileName();
        if (Beanfactory.WEB_DIR != null && !Beanfactory.WEB_DIR.isEmpty()) {
            path = String.valueOf(Beanfactory.WEB_DIR) + File.separator + path;
        }
        File file = new File(path);
        file.getParentFile().mkdirs();
        return file;
    }

    @Override
    public File parseTextFile(String key) {
        String path = String.valueOf(this.parseDir(key)) + File.separator + this.parseTextFileName();
        if (Beanfactory.WEB_DIR != null && !Beanfactory.WEB_DIR.isEmpty()) {
            path = String.valueOf(Beanfactory.WEB_DIR) + File.separator + path;
        }
        File file = new File(path);
        file.getParentFile().mkdirs();
        return file;
    }

    @Override
    public String parseTextFileName() {
        String fileName = "text.txt";
        return fileName;
    }

    @Override
    public File parseLuceneDir() {
        String path = String.valueOf(Beanfactory.WEB_DIR) + File.separator + "index";
        File indexdir = new File(path);
        indexdir.mkdirs();
        return indexdir;
    }
}

