/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.util;

import com.jumipm.onlinedocument.farm.wda.adaptor.DocConvertorBase;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ConfUtils {
    private static Document document;
    private static Map<String, Object> objmap;

    static {
        objmap = new HashMap<String, Object>();
        URL url = ConfUtils.class.getClassLoader().getResource("docTypeConf.xml");
        File file = new File(url.getFile());
        try {
            document = Jsoup.parse((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Set<String> getAcceptTypes() {
        Elements eles = document.getElementsByTag("type");
        HashSet<String> set = new HashSet<String>();
        for (Element node : eles) {
            set.add(node.getElementsByTag("name").text());
        }
        return set;
    }

    public static Map<String, String> getTargetTypes() {
        Elements eles = document.getElementsByTag("file");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Element node : eles) {
            String exname = node.getElementsByTag("exname").text();
            String filename = node.getElementsByTag("filename").text();
            String filepath = node.getElementsByTag("filename").attr("path");
            map.put(exname, String.valueOf(filepath) + File.separator + filename);
        }
        return map;
    }

    public static Map<String, String> getTargetTypes(String fileTypeName) {
        Map<String, String> dic = ConfUtils.getTargetTypes();
        HashMap<String, String> map = new HashMap<String, String>();
        Elements eles = document.getElementsByTag("type");
        for (Element type : eles) {
            if (!type.getElementsByTag("name").text().toUpperCase().equals(fileTypeName.toUpperCase())) continue;
            for (Element exname : type.getElementsByTag("target").get(0).getElementsByTag("exname")) {
                map.put(exname.text(), dic.get(exname.text()));
            }
        }
        return map;
    }

    public static DocConvertorBase getConvertor(String fileTypeName, String targetTypeName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Elements eles = document.getElementsByTag("type");
        for (Element type : eles) {
            if (!type.getElementsByTag("name").text().toUpperCase().equals(fileTypeName.toUpperCase())) continue;
            Elements targetexnames = type.getElementsByTag("exname");
            for (Element targetexname : targetexnames) {
                if (!targetexname.text().toUpperCase().equals(targetTypeName.toUpperCase())) continue;
                String className = targetexname.attr("impl").trim();
                DocConvertorBase convertor = (DocConvertorBase)objmap.get(className);
                if (convertor == null) {
                    Class<?> obj = Class.forName(className);
                    convertor = (DocConvertorBase)obj.newInstance();
                    objmap.put(className, convertor);
                }
                return convertor;
            }
        }
        throw new RuntimeException("\u672a\u627e\u5230\u8f6c\u6362\u5668\uff1a" + fileTypeName + " to " + targetTypeName);
    }
}

