/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.util;

import com.jumipm.onlinedocument.farm.wda.util.AppConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    public static Log log = LogFactory.getLog(FileUtil.class);
    private static final String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
    private static final String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
    private static final String regEx_html = "<[^>]+>";
    private static final String regEx_space = "\\s*|\t|\r|\n";

    public static String readTxtFile(File file, String encodeset) {
        StringBuffer buffer;
        block14: {
            buffer = new StringBuffer();
            InputStreamReader read = null;
            InputStream inputStream = null;
            try {
                try {
                    String encoding = encodeset;
                    if (file.isFile() && file.exists()) {
                        inputStream = new FileInputStream(file);
                        read = new InputStreamReader(inputStream, encoding);
                        BufferedReader bufferedReader = new BufferedReader(read);
                        String lineTxt = null;
                        while ((lineTxt = bufferedReader.readLine()) != null) {
                            buffer.append(lineTxt);
                        }
                        read.close();
                    } else {
                        log.error((Object)"\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519" + e));
                    try {
                        read.close();
                        inputStream.close();
                    }
                    catch (Exception e2) {
                        log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519" + e2));
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    read.close();
                    inputStream.close();
                }
                catch (Exception e) {
                    log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519" + e));
                }
                throw throwable;
            }
            try {
                read.close();
                inputStream.close();
            }
            catch (Exception e) {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519" + e));
            }
        }
        return buffer.toString();
    }

    public static String readTxtFile(File file) {
        StringBuffer buffer;
        block14: {
            buffer = new StringBuffer();
            InputStreamReader read = null;
            InputStream inputStream = null;
            try {
                try {
                    String encoding = AppConfig.getString("config.file.encode");
                    if (file.isFile() && file.exists()) {
                        inputStream = new FileInputStream(file);
                        read = new InputStreamReader(inputStream, encoding);
                        BufferedReader bufferedReader = new BufferedReader(read);
                        String lineTxt = null;
                        while ((lineTxt = bufferedReader.readLine()) != null) {
                            buffer.append(lineTxt);
                        }
                        read.close();
                    } else {
                        log.error((Object)"\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519" + e));
                    try {
                        read.close();
                        inputStream.close();
                    }
                    catch (Exception e2) {
                        log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519" + e2));
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    read.close();
                    inputStream.close();
                }
                catch (Exception e) {
                    log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519" + e));
                }
                throw throwable;
            }
            try {
                read.close();
                inputStream.close();
            }
            catch (Exception e) {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519" + e));
            }
        }
        return buffer.toString();
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static void wirteLog(File log2, String message) {
        try {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd   hh:mm:ss");
            String date = sDateFormat.format(new Date());
            if (!log2.exists()) {
                log2.createNewFile();
            }
            try (RandomAccessFile raf = new RandomAccessFile(log2, "rw");){
                try {
                    long fileLength = raf.length();
                    raf.seek(fileLength);
                    raf.writeBytes("Log0N  " + date + ":   " + message + "\r\n");
                }
                catch (IOException e1) {
                    log.error((Object)e1);
                    raf.close();
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)e2);
        }
    }

    public static void wirteInfo(File file, String text) {
        FileOutputStream out = null;
        try {
            try {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    out = new FileOutputStream(file, false);
                    out.write(text.getBytes(AppConfig.getString("config.file.encode")));
                    out.close();
                }
                catch (IOException ex) {
                    log.error((Object)ex);
                    out.close();
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public static String delHTMLTag(String htmlStr) {
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        Pattern p_space = Pattern.compile(regEx_space, 2);
        Matcher m_space = p_space.matcher(htmlStr);
        htmlStr = m_space.replaceAll("");
        return htmlStr.trim().replaceAll("&nbsp;", "");
    }

    public static String matchCharset(String content) {
        String chs = "UTF-8";
        Pattern p = Pattern.compile("(?<=charset=)(.+)(?=\")");
        Matcher m = p.matcher(content);
        if (m.find()) {
            return m.group();
        }
        return chs;
    }

    public static String getCharSet(String html) {
        String charset;
        charset = charset.substring(0, (charset = FileUtil.matchCharset(html).replaceAll("'", "\"")).indexOf("\"") > 0 ? charset.indexOf("\"") : charset.length());
        return charset.trim();
    }
}

