/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.util;

import com.jumipm.onlinedocument.farm.wda.util.AppConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ZipUtils {
    public static void unHtmlZipFiles(File zipFile, String descDir) throws IOException {
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        ZipFile zip = new ZipFile(zipFile);
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = (ZipEntry)entries.nextElement();
            String zipEntryName = entry.getName();
            zipEntryName = ZipUtils.enCodeChar(zipEntryName);
            InputStream in = zip.getInputStream(entry);
            String outPath = (String.valueOf(descDir) + zipEntryName).replaceAll("\\\\", "/");
            File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
            if (!file.exists()) {
                file.mkdirs();
            }
            if (new File(outPath).isDirectory()) continue;
            outPath.indexOf("Footer_LightBlue.html");
            FileOutputStream out = new FileOutputStream(outPath);
            byte[] buf1 = new byte[1024];
            while ((len = in.read(buf1)) > 0) {
                ((OutputStream)out).write(buf1, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            ZipUtils.reCodeFilesUrl_link(new File(outPath));
        }
        System.out.println("******************\u89e3\u538b\u5b8c\u6bd5********************");
    }

    public static String enCodeChar(String str) throws UnsupportedEncodingException {
        String ylStr = str;
        str = str.replaceAll("%20", " ");
        str = str.replaceAll("/", "_2343321_");
        str = str.replaceAll("#", "_1246721_");
        String newstr = URLEncoder.encode(str = str.replaceAll(" ", "_1311105_"), "UTF-8");
        int lastnum = newstr.lastIndexOf("_2343321_");
        if (lastnum < 0) {
            lastnum = 0;
        }
        if (newstr.substring(lastnum).length() > 200) {
            return ylStr;
        }
        newstr = newstr.replaceAll("%", "A");
        newstr = newstr.replaceAll("_2343321_", "/");
        newstr = newstr.replaceAll("_1246721_", "#");
        newstr = newstr.replaceAll("_1311105_", " ");
        return newstr;
    }

    public static void reCodeFilesUrl_link(File file) throws IOException {
        String charSet = "utf-8";
        Document docChar = Jsoup.parse((File)file, (String)"UTF-8");
        if (file.getName().toUpperCase().indexOf(".HTML") > 0 || file.getName().toUpperCase().indexOf(".HTM") > 0) {
            Elements metas = docChar.getElementsByTag("meta");
            for (Element node : metas) {
                if (node.attr("content").toUpperCase().indexOf("CHARSET") < 0) continue;
                charSet = node.attr("content").substring(node.attr("content").toUpperCase().indexOf("CHARSET") + 8);
                break;
            }
        }
        if (file.getName().toUpperCase().indexOf(".HTML") < 0 && file.getName().toUpperCase().indexOf(".HTM") < 0) {
            return;
        }
        Document doc = Jsoup.parse((File)file, (String)charSet);
        if (file.getName().toUpperCase().indexOf(".HTML") > 0 || file.getName().toUpperCase().indexOf(".HTM") > 0) {
            Elements metas = doc.getElementsByTag("meta");
            for (Element node : metas) {
                if (node.attr("content").toUpperCase().indexOf("CHARSET") < 0) continue;
                node.attr("content", "text/html; charset=utf-8");
            }
        }
        Elements frames = doc.getAllElements();
        for (Element node : frames) {
            if (node.attr("href") != null && !node.attr("href").trim().equals("")) {
                node.attr("href", ZipUtils.enCodeChar(node.attr("href")));
            }
            if (node.attr("src") == null || node.attr("src").trim().equals("")) continue;
            node.attr("src", ZipUtils.enCodeChar(node.attr("src")));
        }
        for (Element node : doc.getElementsByTag("title")) {
            StringBuffer str = new StringBuffer();
            str.append(AppConfig.getString("config.web.title"));
            node.prepend(String.valueOf(str.toString()) + ":");
        }
        FileOutputStream fos = new FileOutputStream(file, false);
        fos.write(doc.html().getBytes("utf-8"));
        fos.close();
    }
}

