/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.adaptor.impl;

import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.jumipm.onlinedocument.farm.wda.Beanfactory;
import com.jumipm.onlinedocument.farm.wda.adaptor.DocConvertorBase;
import com.jumipm.onlinedocument.farm.wda.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.net.ConnectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class DocToHtmlConvertor
extends DocConvertorBase {
    public static Log log = LogFactory.getLog(DocToHtmlConvertor.class);

    @Override
    public void run(File file, String fileTypeName, File targetFile) {
        SocketOpenOfficeConnection con = new SocketOpenOfficeConnection(8100);
        try {
            con.connect();
        }
        catch (ConnectException e) {
            log.error((Object)("\u83b7\u53d6OpenOffice\u8fde\u63a5\u5931\u8d25..." + e.getMessage()));
        }
        try {
            try {
                OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter((OpenOfficeConnection)con);
                DefaultDocumentFormatRegistry formatReg = new DefaultDocumentFormatRegistry();
                DocumentFormat pdfFormat = formatReg.getFormatByFileExtension(fileTypeName.toLowerCase());
                DocumentFormat docFormat = formatReg.getFormatByFileExtension(FileUtil.getExtensionName(targetFile.getName()));
                converter.convert(file, pdfFormat, targetFile, docFormat);
                log.info((Object)("\u6210\u529f\u8f6c\u6362\uff1a" + file + "\u8f6c\u6362\u5230" + targetFile));
                String charset = FileUtil.getCharSet(FileUtil.readTxtFile(targetFile));
                Document htmldoc = Jsoup.parse((File)targetFile, (String)charset);
                Elements head = htmldoc.getElementsByTag("HEAD");
                head.append("<link href=\"" + Beanfactory.WEB_URL + "/css/wdacontent.css\" rel=\"stylesheet\" type=\"text/css\" />");
                Elements body = htmldoc.getElementsByTag("body");
                String bodyhtml = body.html();
                body.html("");
                body.append("<div class=\"wdahtmlbox\">" + bodyhtml + "</div>");
                FileOutputStream fos = new FileOutputStream(targetFile);
                fos.write(htmldoc.toString().getBytes(charset));
                fos.close();
            }
            catch (Exception e) {
                log.error((Object)("\u8f6c\u6362\u9519\u8bef" + e + "/" + file + "\u8f6c\u6362\u5230" + targetFile));
                throw new RuntimeException(e);
            }
        }
        finally {
            con.disconnect();
        }
    }
}

