/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.adaptor.impl;

import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.jumipm.onlinedocument.farm.wda.adaptor.DocConvertorBase;
import com.jumipm.onlinedocument.farm.wda.util.AppConfig;
import com.jumipm.onlinedocument.farm.wda.util.FileUtil;
import java.io.File;
import java.net.ConnectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenOfficeConvertor
extends DocConvertorBase {
    public static Log log = LogFactory.getLog(OpenOfficeConvertor.class);

    @Override
    public void run(File file, String fileTypeName, File targetFile) {
        SocketOpenOfficeConnection con = new SocketOpenOfficeConnection(Integer.valueOf(AppConfig.getString("config.openoffice.port")).intValue());
        try {
            con.connect();
        }
        catch (ConnectException e) {
            log.error((Object)("\u83b7\u53d6OpenOffice\u8fde\u63a5\u5931\u8d25..." + e.getMessage()));
        }
        try {
            try {
                OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter((OpenOfficeConnection)con);
                DefaultDocumentFormatRegistry formatReg = new DefaultDocumentFormatRegistry();
                DocumentFormat pdfFormat = formatReg.getFormatByFileExtension(fileTypeName.toLowerCase());
                DocumentFormat docFormat = formatReg.getFormatByFileExtension(FileUtil.getExtensionName(targetFile.getName()));
                converter.convert(file, pdfFormat, targetFile, docFormat);
                log.info((Object)("\u6210\u529f\u8f6c\u6362\uff1a" + file + "\u8f6c\u6362\u5230" + targetFile));
            }
            catch (Exception e) {
                log.error((Object)("\u8f6c\u6362\u9519\u8bef" + e + "/" + file + "\u8f6c\u6362\u5230" + targetFile));
                throw new RuntimeException(e);
            }
        }
        finally {
            con.disconnect();
        }
    }
}

