/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.adaptor.impl;

import com.jumipm.onlinedocument.farm.wda.adaptor.DocConvertorBase;
import com.jumipm.onlinedocument.farm.wda.common.CompressFile;
import com.jumipm.onlinedocument.farm.wda.util.CharUtils;
import com.jumipm.onlinedocument.farm.wda.util.FileUtil;
import com.sun.star.uno.RuntimeException;
import java.io.File;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipRarToHtmlConvertor
extends DocConvertorBase {
    public static Log log = LogFactory.getLog(ZipRarToHtmlConvertor.class);

    @Override
    public void run(File file, String fileTypeName, File targetFile) {
        try {
            log.debug((Object)("\u89e3\u538b\u6587\u4ef6" + file.getPath()));
            log.debug((Object)("\u89e3\u538b\u76ee\u5f55" + targetFile.getPath()));
            ZipRarToHtmlConvertor.deCompress(file.getPath(), fileTypeName, targetFile.getParent());
            File[] files = targetFile.getParentFile().listFiles();
            StringBuffer buffer = new StringBuffer();
            buffer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
            buffer.append("<html><head>");
            buffer.append("<meta http-equiv=\"CONTENT-TYPE\" content=\"text/html; charset=utf-8\" /> ");
            buffer.append("<title></title>");
            buffer.append("<link href=\"/wda/css/wdacontent.css\" rel=\"stylesheet\" type=\"text/css\" />");
            buffer.append("</head>");
            buffer.append("<body><div class=\"wdaTitleBox\"><img src=\"/wda/img/htmllogo.png\" /></div>");
            buffer.append("<div class=\"wdahtmlbox\">");
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File dirfile = fileArray[n2];
                if (!dirfile.equals("index.html")) {
                    if (!dirfile.isDirectory()) {
                        String fileName = dirfile.getName();
                        if (CharUtils.isChinese(fileName)) {
                            buffer.append(String.valueOf(dirfile.getName()) + "<br/>");
                        } else if (fileName.toLowerCase().endsWith(".jsp")) {
                            buffer.append(String.valueOf(dirfile.getName()) + "<br/>");
                        } else {
                            buffer.append("<a href='" + URLEncoder.encode(dirfile.getName(), "utf-8") + "'>" + dirfile.getName() + "</a><br/>");
                        }
                    } else {
                        buffer.append(String.valueOf(dirfile.getName()) + "[\u76ee\u5f55]<br/>");
                    }
                }
                ++n2;
            }
            buffer.append("</div>");
            buffer.append("</body>");
            buffer.append("</html>");
            FileUtil.wirteInfo(targetFile, buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void deCompress(String sourceFile, String filetype, String destDir) throws Exception {
        char lastChar = destDir.charAt(destDir.length() - 1);
        if (lastChar != '/' && lastChar != '\\') {
            destDir = String.valueOf(destDir) + File.separator;
        }
        String type = sourceFile.substring(sourceFile.lastIndexOf(".") + 1);
        if (filetype != null) {
            type = filetype;
        }
        if (type.toLowerCase().equals("zip")) {
            CompressFile.unZipFiles(new File(sourceFile), destDir);
        } else if (type.toLowerCase().equals("rar")) {
            CompressFile.unRarFile(sourceFile, destDir);
        } else {
            throw new Exception("\u53ea\u652f\u6301zip\u548crar\u683c\u5f0f\u7684\u538b\u7f29\u5305\uff01");
        }
    }
}

