/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.farm.wda.impl;

import com.farm.wda.exception.ErrorTypeException;
import com.farm.wda.inter.WdaAppInter;
import com.farm.wda.lucene.FarmLuceneFace;
import com.farm.wda.lucene.adapter.DocMap;
import com.farm.wda.lucene.server.DocIndexInter;
import com.jumipm.onlinedocument.farm.wda.Beanfactory;
import com.jumipm.onlinedocument.farm.wda.domain.DocTask;
import com.jumipm.onlinedocument.farm.wda.util.AppConfig;
import com.jumipm.onlinedocument.farm.wda.util.ConfUtils;
import com.jumipm.onlinedocument.farm.wda.util.FileUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Field;

public class WdaAppImpl
extends UnicastRemoteObject
implements WdaAppInter {
    private static final long serialVersionUID = -7645009054057448060L;
    public static Queue<DocTask> tasks = new LinkedList<DocTask>();
    public static Log log = LogFactory.getLog(WdaAppImpl.class);

    public boolean isGenerated(String key, String doctype) throws ErrorTypeException {
        if (!ConfUtils.getTargetTypes().containsKey(doctype)) {
            throw new ErrorTypeException("\u8be5\u7c7b\u578b\u65e0\u6548\uff1a" + doctype);
        }
        File tarfile = Beanfactory.getFileKeyCoderImpl().parseFile(key, doctype);
        return tarfile.isFile();
    }

    public String getText(String key) throws ErrorTypeException {
        String text = null;
        File textFile = Beanfactory.getFileKeyCoderImpl().parseTextFile(key);
        if (textFile.exists()) {
            text = FileUtil.readTxtFile(textFile, AppConfig.getString("config.file.encode"));
        } else {
            File file = null;
            String str = null;
            file = Beanfactory.getFileKeyCoderImpl().parseFile(key, "TXT");
            if (!file.exists() || file.length() <= 0L) {
                file = Beanfactory.getFileKeyCoderImpl().parseFile(key, "HTML");
                if (file.exists()) {
                    String charset;
                    str = FileUtil.readTxtFile(file);
                    charset = charset.substring(0, (charset = FileUtil.matchCharset(str).replaceAll("'", "\"")).indexOf("\"") > 0 ? charset.indexOf("\"") : charset.length());
                    str = FileUtil.readTxtFile(file, charset.trim());
                }
            } else {
                str = FileUtil.readTxtFile(file);
            }
            if (file != null && file.exists()) {
                try {
                    text = String.valueOf(FileUtil.delHTMLTag(str)) + "/" + this.getInfo(key);
                    FileUtil.wirteInfo(textFile, text);
                    this.index(key, this.getInfo(key), text);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
        return text;
    }

    private void index(String key, String name, String text) throws Exception {
        if (!AppConfig.getString("config.index").equals("true")) {
            return;
        }
        try (DocIndexInter indexserver = FarmLuceneFace.inctance().getDocIndex(Beanfactory.getFileKeyCoderImpl().parseLuceneDir());){
            DocMap doc = new DocMap(key);
            doc.put("TEXT", text, Field.Store.YES, Field.Index.ANALYZED);
            doc.put("NAME", name, Field.Store.YES, Field.Index.ANALYZED);
            doc.put("KEY", key, Field.Store.YES, Field.Index.ANALYZED);
            indexserver.indexDoc(doc);
        }
    }

    public String getInfo(String key) throws ErrorTypeException, RemoteException {
        String str = null;
        File file = null;
        file = Beanfactory.getFileKeyCoderImpl().parseInfoFile(key);
        if (!file.exists()) {
            return "\u65e0\u4fe1\u606f";
        }
        str = FileUtil.readTxtFile(file);
        log.debug((Object)("\u8bfb\u53d6INFO\uff1a" + str));
        return str;
    }

    public String getUrl(String key, String exname) throws ErrorTypeException {
        String path = String.valueOf(Beanfactory.getFileKeyCoderImpl().parseDir(key)) + File.separator + Beanfactory.getFileKeyCoderImpl().parseFileName(exname);
        String webpaht = AppConfig.getString("config.file.dir.web.path");
        webpaht = File.separator.equals("/") ? webpaht.replace("\\\\", "/") : webpaht.replace("/", "\\");
        return (String.valueOf(webpaht.replace("WEBROOT" + File.separator, "")) + File.separator + path).replaceAll("\\\\", "/");
    }

    public void generateDoc(String key, File file, String fileTypeName, String info, String authid) throws ErrorTypeException {
        FileUtil.wirteInfo(Beanfactory.getFileKeyCoderImpl().parseInfoFile(key), info);
        for (String tkey : ConfUtils.getTargetTypes(fileTypeName).keySet()) {
            File tarfile = Beanfactory.getFileKeyCoderImpl().parseFile(key, tkey);
            log.info((Object)("\u63d0\u4ea4\u4efb\u52a1\u5230\u961f\u5217\uff1a" + tarfile));
            File logFile = Beanfactory.getFileKeyCoderImpl().parseLogFile(key);
            FileUtil.wirteLog(logFile, "submitted to taskQueue,waiting...");
            tasks.add(new DocTask(key, file, fileTypeName, tarfile, logFile, Beanfactory.getFileKeyCoderImpl().parseInfoFile(key), info, tkey, authid));
        }
    }

    public void generateDoc(String key, File file, String info, String authid) throws ErrorTypeException {
        this.generateDoc(key, file, FileUtil.getExtensionName(file.getName()), info, authid);
    }

    public boolean isLoged(String key) {
        File file = Beanfactory.getFileKeyCoderImpl().parseLogFile(key);
        return file.isFile();
    }

    public String getlogURL(String key) {
        String path = String.valueOf(Beanfactory.getFileKeyCoderImpl().parseDir(key)) + File.separator + Beanfactory.getFileKeyCoderImpl().parseLogFileName();
        String webpaht = AppConfig.getString("config.file.dir.web.path");
        webpaht = File.separator.equals("/") ? webpaht.replace("\\\\", "/") : webpaht.replace("/", "\\");
        return (String.valueOf(webpaht.replace("WEBROOT" + File.separator, "")) + File.separator + path).replaceAll("\\\\", "/");
    }

    public Set<String> getSupportTypes() throws RemoteException {
        return ConfUtils.getAcceptTypes();
    }

    public void delLog(String key) throws RemoteException {
        File file = Beanfactory.getFileKeyCoderImpl().parseLogFile(key);
        file.deleteOnExit();
    }

    public String getLogText(String key) throws RemoteException {
        File log = Beanfactory.getFileKeyCoderImpl().parseLogFile(key);
        String text = FileUtil.readTxtFile(log, AppConfig.getString("config.file.encode"));
        text = text.replaceAll("Log0N", "<br/>");
        return text;
    }

    public void clearDir(String key) throws RemoteException {
        String dirStr = Beanfactory.getFileKeyCoderImpl().parseDir(key);
        String paht = String.valueOf(Beanfactory.WEB_DIR) + File.separator + dirStr;
        this.deleteFile(new File(paht));
    }

    private void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.deleteFile(files[i]);
                    ++i;
                }
                file.delete();
            }
        } else {
            System.out.println("\u6240\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public List<Map<String, String>> getTasksinfo() throws RemoteException {
        ArrayList<Map<String, String>> taskcopys = new ArrayList<Map<String, String>>();
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY/MM/dd HH:mm:ss");
        HashMap<String, String> dicmap = new HashMap<String, String>();
        dicmap.put("1", "\u7b49\u5f85");
        dicmap.put("2", "\u5904\u7406\u4e2d");
        for (DocTask task : tasks) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("AUTHID", task.getAuthid());
            map.put("TYPENAME", task.getFileTypeName());
            map.put("INFO", task.getInfo());
            map.put("KEY", task.getKey());
            map.put("TARGETTYPE", task.getTargettype());
            map.put("STATE", (String)dicmap.get(task.getState()));
            map.put("PATH", Beanfactory.getFileKeyCoderImpl().parseDir(task.getKey()));
            map.put("CTIME", task.getCtime() != null ? sdf.format(task.getCtime()) : "");
            map.put("STIME", task.getStime() != null ? sdf.format(task.getStime()) : "");
            taskcopys.add(map);
        }
        return taskcopys;
    }
}

