/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.onlinedocument.util.impl;

import com.farm.wda.exception.ErrorTypeException;
import com.farm.wda.inter.WdaAppInter;
import com.jumipm.onlinedocument.farm.wda.Beanfactory;
import com.jumipm.onlinedocument.farm.wda.domain.DocTask;
import com.jumipm.onlinedocument.farm.wda.impl.WdaAppImpl;
import com.jumipm.onlinedocument.farm.wda.util.AppConfig;
import com.jumipm.onlinedocument.util.OfficeViewUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;

public class OfficeViewUtilImpl
implements OfficeViewUtil {
    private final Logger log = Logger.getLogger(this.getClass());
    private static String imagetype = AppConfig.getString("config.imagetype");
    private static WdaAppInter wad = Beanfactory.getWdaAppImpl();
    private static Set<String> s = null;
    private static String viewtype = AppConfig.getString("config.viewtype");

    @Override
    public boolean getlisten(String key, Map<String, Object> map) {
        boolean b = false;
        Queue<DocTask> tasks = WdaAppImpl.tasks;
        if (!tasks.isEmpty()) {
            for (DocTask docTask : tasks) {
                if (!key.equals(docTask.getKey())) continue;
                b = true;
                map.put("state", docTask.getState());
            }
        }
        return b;
    }

    @Override
    public boolean isChange(String type) throws RemoteException {
        if (s == null) {
            s = wad.getSupportTypes();
        }
        return s.toString().concat(imagetype).indexOf(type) >= 0;
    }

    @Override
    public String generateDoc(String key, File file, String htmlinfo, String authid) throws RemoteException, ErrorTypeException {
        wad.generateDoc(key, file, htmlinfo, authid);
        this.log.info((Object)("\n\u83b7\u5f97\u8f6c\u6362\u4efb\u52a1\u4fe1\u606f\u961f\u5217" + wad.getTasksinfo()));
        return wad.getUrl(key, viewtype);
    }

    @Override
    public String generateDoc(String key, File file, String fileTypeName, String htmlinfo, String authid) throws RemoteException, ErrorTypeException {
        fileTypeName = this.changType(fileTypeName);
        wad.generateDoc(key, file, fileTypeName, htmlinfo, authid);
        this.log.info((Object)("\n\u83b7\u5f97\u8f6c\u6362\u4efb\u52a1\u4fe1\u606f\u961f\u5217" + wad.getTasksinfo()));
        return this.getUrl(key, fileTypeName);
    }

    @Override
    public List<Map<String, String>> getTasksinfo() throws RemoteException {
        return wad.getTasksinfo();
    }

    @Override
    public String getUrl(String key, String fileType) throws RemoteException, ErrorTypeException {
        String now_viewtype = viewtype;
        if (".ppt,pptx".indexOf(fileType) >= 0) {
            now_viewtype = "HTML";
        }
        return wad.getUrl(key, now_viewtype);
    }

    @Override
    public boolean isEndOrError(String key) throws RemoteException, ErrorTypeException {
        boolean isEndOrError = false;
        boolean isError = false;
        boolean isHaveFile = false;
        if (wad.getLogText(key) == null) {
            isError = false;
        } else {
            boolean bl = isError = wad.getLogText(key).indexOf("error") >= 0;
        }
        if (wad.isGenerated(key, viewtype) || wad.isGenerated(key, "HTML")) {
            isHaveFile = true;
        }
        isEndOrError = isHaveFile || isError;
        this.log.info((Object)("\n" + viewtype + " isHaveFile>>>" + isHaveFile));
        return isEndOrError;
    }

    @Override
    public String getViewType() {
        return viewtype;
    }

    private String changType(String type) {
        switch (type) {
            case "docx": {
                type = "doc";
                break;
            }
            case "pptx": {
                type = "ppt";
                break;
            }
            case "xlsx": {
                type = "xls";
                break;
            }
        }
        return type;
    }
}

