/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.crypto.impl;

import com.jumipm.common.crypto.JumiCrypto;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesCrypto
implements JumiCrypto {
    private static final Logger log = LoggerFactory.getLogger(AesCrypto.class);
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/ECB/PKCS7Padding";

    @Override
    public String encrypt(String plainText, String key) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), ALGORITHM);
        byte[] encryptedBytes = new byte[]{};
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION, "BC");
            cipher.init(1, keySpec);
            encryptedBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Hex.toHexString((byte[])encryptedBytes);
    }

    @Override
    public String decrypt(String encryptedText, String key) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), ALGORITHM);
        byte[] decryptedBytes = new byte[]{};
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION, "BC");
            cipher.init(2, keySpec);
            decryptedBytes = cipher.doFinal(Hex.decode((String)encryptedText));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }
}

