/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.crypto.utils;

import com.jumipm.common.crypto.JumiCrypto;
import com.jumipm.common.crypto.impl.AesCrypto;
import com.jumipm.common.crypto.impl.Sm2Crypto;
import com.jumipm.common.crypto.impl.Sm4Crypto;
import java.util.HashMap;
import java.util.Map;

public class JumiCryptoUtil {
    private static Map<String, JumiCrypto> cryptos = new HashMap<String, JumiCrypto>();
    public static final String AesCrypto = "AesCrypto";
    public static final String Sm2Crypto = "Sm2Crypto";
    public static final String Sm4Crypto = "Sm4Crypto";

    public static String encrypt(String plainText, String key, String type) {
        return cryptos.get(type).encrypt(plainText, key);
    }

    public static String decrypt(String encryptedText, String key, String type) {
        return cryptos.get(type).decrypt(encryptedText, key);
    }

    static {
        cryptos.put(AesCrypto, new AesCrypto());
        cryptos.put(Sm2Crypto, new Sm2Crypto());
        cryptos.put(Sm4Crypto, new Sm4Crypto());
    }
}

