/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(CodeGenerator.class);
    private static final char[] CHR_CODE_SCOPE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private static final char[] CHRS_SCOPE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] INT_CODE_SCOPE = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private static Snowflake snowflake = null;

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getLinkCode(int len) {
        Random random = new Random();
        String str = "";
        for (int i = 0; i < len; ++i) {
            str = str + CHR_CODE_SCOPE[random.nextInt(35)];
        }
        return str;
    }

    public static String getRandomIntCode(int len) {
        Random random = new Random();
        String str = "";
        for (int i = 0; i < len; ++i) {
            str = str + INT_CODE_SCOPE[random.nextInt(10)];
        }
        return str;
    }

    public static String getRandomCharCode(int len) {
        Random random = new Random();
        String str = "";
        for (int i = 0; i < len; ++i) {
            str = str + CHRS_SCOPE[random.nextInt(26)];
        }
        return str;
    }

    public static String get6IntCode() {
        Random random = new Random();
        String str = "";
        for (int i = 0; i < 6; ++i) {
            str = str + INT_CODE_SCOPE[random.nextInt(9)];
        }
        return str;
    }

    public static String getTimestamp() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new Date().getTime() + "";
    }

    public static String getSnowflake() {
        return snowflake.nextIdStr();
    }

    static {
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(System.currentTimeMillis());
        long workerId = new Long(secureRandom.nextInt(31));
        long datacenterId = new Long(secureRandom.nextInt(31));
        log.info("workerId is {}, datacenterId is {}", (Object)workerId, (Object)datacenterId);
        snowflake = IdUtil.getSnowflake((long)workerId, (long)datacenterId);
    }
}

