/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.license.service;

import com.jumipm.common.exception.BusinessException;
import com.jumipm.common.utils.LicenseVerifyCore;
import com.jumipm.common.utils.RSADecryptUtil;
import com.jumipm.license.user.XpmUserDataJdbc;
import com.jumipm.utils.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class LicenseInfo {
    private String key = "";
    private String msage = "";
    private String msage_ = "";
    private String data = "";
    private String count = "";
    private int warningMinDays = 7;
    private String warningmsg = "";
    private int projectCount = 0;
    private String licClient = "";
    private Set<String> clientList;

    public LicenseInfo() {
        this.setParam();
    }

    public void setParam() {
        try {
            Properties prop = new Properties();
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("verifyparam.properties");
            prop.load(in);
            this.key = prop.getProperty("license.key");
            this.msage = prop.getProperty("license.msg");
            try {
                this.warningMinDays = Integer.valueOf(prop.getProperty("license.expiration_days"));
            }
            catch (Exception e) {
                this.warningMinDays = 7;
            }
            this.msage_ = RSADecryptUtil.decrypt(this.msage, this.key);
            String[] split = this.msage_.split("\\|\\|");
            if (split.length != 5) {
                throw new BusinessException("\u6388\u6743\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38");
            }
            this.data = split[0];
            this.count = split[1];
            this.projectCount = Integer.parseInt(split[2]);
            this.licClient = split[3];
            String clients = split[4];
            List<String> strings = StrUtil.arrayToList(clients.split(","));
            this.clientList = new HashSet<String>(strings);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean verify() {
        if (this.msage_.isEmpty() || this.data.isEmpty() || this.count.isEmpty()) {
            return false;
        }
        if (!"0000-00-00".equals(this.data)) {
            int days = LicenseVerifyCore.getValidityPeriod(this.data);
            if (0 <= days && days <= this.warningMinDays) {
                this.warningmsg = "verifyparam\u6587\u4ef6\u6709\u6548\u671f\u8fd8\u5269" + days + "\u5929\u5c31\u5230\u671f\u4e86\u8bf7\u83b7\u53d6\u65b0\u7684\u6587\u4ef6";
            }
            if (days < 0) {
                return false;
            }
        }
        if (Integer.valueOf(this.count) > 0) {
            Integer usercount = XpmUserDataJdbc.getUserCount();
            if (null == usercount) {
                return false;
            }
            if (Integer.valueOf(this.count) < usercount) {
                return false;
            }
        }
        if (this.projectCount > 0) {
            Integer projectCount = XpmUserDataJdbc.getProjectCount();
            if (null == projectCount) {
                return false;
            }
            if (this.projectCount < projectCount) {
                return false;
            }
        }
        return true;
    }

    public String getKey() {
        return this.key;
    }

    protected String getData() {
        if (StrUtil.isNull(this.data) || "0000-00-00".equals(this.data)) {
            return null;
        }
        return this.data;
    }

    protected String getCount() {
        if (StrUtil.isNull(this.count) || 0 >= Integer.valueOf(this.count)) {
            return null;
        }
        return this.count;
    }

    protected String getWarningmsg() {
        return this.warningmsg;
    }

    protected int getProjectCount() {
        return this.projectCount;
    }

    public String getLicClient() {
        return this.licClient;
    }

    public Set<String> getClientList() {
        return this.clientList;
    }
}

