/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.license.service;

import com.alibaba.fastjson.JSONObject;
import com.jumipm.common.utils.VerifyParam;
import com.jumipm.license.service.LicenseInfo;
import com.jumipm.utils.CryptHelper;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Repository;

@Order(value=1)
@Repository
public final class VerifyLicense
implements ApplicationContextAware {
    public static Log log = LogFactory.getLog(VerifyLicense.class);
    private static ApplicationContext applicationContext;
    private static LicenseInfo linfo;
    @Value(value="${config.server.domain}")
    private String serverDomain;
    private AtomicLong count = new AtomicLong(0L);
    private CloseableHttpClient httpClient = HttpClients.createDefault();

    @PostConstruct
    private static void init() {
        LicenseInfo licInfo = new LicenseInfo();
        VerifyParam.data = licInfo.getData();
        VerifyParam.count = licInfo.getCount();
        VerifyParam.warningmsg = licInfo.getWarningmsg();
        boolean verify = licInfo.verify();
        if (!verify) {
            ((AbstractApplicationContext)applicationContext).close();
        }
        linfo = licInfo;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public boolean licInfoVerify() {
        try {
            long l = this.count.incrementAndGet();
            long l1 = l % 100L;
            if (l1 != 0L) {
                return true;
            }
            if (l >= Integer.MAX_VALUE) {
                this.count.set(0L);
            }
            HttpPost httpPost = new HttpPost(this.serverDomain + "/licInfoVerify");
            httpPost.setConfig(RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).build());
            httpPost.addHeader("Content-Type", "application/json");
            JSONObject body = new JSONObject();
            Long now = System.currentTimeMillis();
            body.put("now", (Object)now);
            body.put("client", (Object)CryptHelper.aesEncrypt(linfo.getLicClient(), now.toString()));
            httpPost.setEntity((HttpEntity)new StringEntity(body.toJSONString(), "utf-8"));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            JSONObject jsonObject = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            String s = CryptHelper.aesDecrypt(jsonObject.getString("returnData"), now.toString());
            if (!"true".equalsIgnoreCase(s)) {
                log.debug((Object)"licInfoVerify >>>>>>>>>>>>");
                return false;
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
        }
        return true;
    }

    public boolean whitelistVerify(String client) {
        try {
            return linfo.getClientList().contains(client);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

