/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.utils;

import com.jumipm.utils.DateUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;

public class LicenseVerifyCore {
    public static int getValidityPeriod(String validityPeriod) {
        Date now = new Date();
        Date validitydate = DateUtils.stringToDate(validityPeriod);
        validitydate.setHours(0);
        validitydate.setMinutes(0);
        validitydate.setSeconds(0);
        now.setHours(0);
        now.setMinutes(0);
        now.setSeconds(0);
        return DateUtils.calculateDaysByDate(now, validitydate);
    }

    public static String getLocalMac(InetAddress ia) throws SocketException, UnknownHostException {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mac.length; ++i) {
            int temp;
            String str;
            if (i != 0) {
                sb.append("-");
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
                continue;
            }
            sb.append(str);
        }
        return sb.toString().toUpperCase();
    }

    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }
}

