/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.util;

import com.kotelmems.platform.page.Page;
import com.kotelmems.platform.page.PageRequest;
import com.kotelmems.platform.xsqlbuilder.util.SqlRemoveUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class PageQueryUtils {
    public static String createCountSql(String sql) {
        String countSql = "select count(*) " + SqlRemoveUtils.removeSelect(SqlRemoveUtils.removeFetchKeyword(sql));
        return countSql;
    }

    public static Page pageQuery(HibernateTemplate template, final String hql, final String countHql, final PageRequest pageRequest, final Object parameters) {
        return (Page)template.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = PageQueryUtils.setQueryParameters((Query)session.createQuery(hql), parameters);
                Query countQuery = PageQueryUtils.setQueryParameters((Query)session.createQuery(SqlRemoveUtils.removeOrders(countHql)), parameters);
                return PageQueryUtils.executeQueryForPage(pageRequest, query, countQuery);
            }
        });
    }

    public static Page pageQuery(HibernateTemplate template, final String hql, final String countHql, final PageRequest pageRequest, final Map parameters) {
        return (Page)template.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = PageQueryUtils.setQueryParameters((Query)session.createQuery(hql), parameters);
                Query countQuery = PageQueryUtils.setQueryParameters((Query)session.createQuery(SqlRemoveUtils.removeOrders(countHql)), parameters);
                return PageQueryUtils.executeQueryForPage(pageRequest, query, countQuery);
            }
        });
    }

    public static Page pageSQLQuery(HibernateTemplate template, final String sql, final String countSql, final PageRequest pageRequest, final Object parameters) {
        return (Page)template.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = PageQueryUtils.setQueryParameters((Query)session.createSQLQuery(sql), parameters);
                Query countQuery = PageQueryUtils.setQueryParameters((Query)session.createSQLQuery(SqlRemoveUtils.removeOrders(countSql)), parameters);
                return PageQueryUtils.executeQueryForPage(pageRequest, query, countQuery);
            }
        });
    }

    public static Page pageSQLQuery(HibernateTemplate template, final String sql, final String countSql, final PageRequest pageRequest, final Map parameters) {
        return (Page)template.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = PageQueryUtils.setQueryParameters((Query)session.createSQLQuery(sql), parameters);
                Query countQuery = PageQueryUtils.setQueryParameters((Query)session.createSQLQuery(SqlRemoveUtils.removeOrders(countSql)), parameters);
                return PageQueryUtils.executeQueryForPage(pageRequest, query, countQuery);
            }
        });
    }

    public static Object executeQueryForPage(PageRequest pageRequest, Query query, Query countQuery) {
        Page page = new Page(pageRequest, ((Number)countQuery.uniqueResult()).intValue());
        if (page.getTotalCount() <= 0) {
            page.setResult(new ArrayList(0));
        } else {
            List resultList = query.setFirstResult(pageRequest.getFirstResult()).setMaxResults(pageRequest.getPageSize()).list();
            page.setResult(resultList);
        }
        return page;
    }

    public static Query setQueryParameters(Query q, Object params) {
        q.setProperties(params);
        return q;
    }

    public static Query setQueryParameters(Query q, Map<?, ?> params) {
        q.setProperties(params);
        return q;
    }
}

