/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.util;

import java.net.InetAddress;

public class UUIDHexGenerator {
    private String sep = "";
    private static final int IP;
    private static short counter;
    private static final int JVM;

    public static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    protected String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuffer buf = new StringBuffer("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    protected String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuffer buf = new StringBuffer("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    protected int getJVM() {
        return JVM;
    }

    protected synchronized short getCount() {
        if (counter < 0) {
            counter = 0;
        }
        short s = counter;
        counter = (short)(s + 1);
        return s;
    }

    protected int getIP() {
        return IP;
    }

    protected short getHiTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    protected int getLoTime() {
        return (int)System.currentTimeMillis();
    }

    public String generate() {
        return new StringBuffer(36).append(this.format(this.getIP())).append(this.sep).append(this.format(this.getJVM())).append(this.sep).append(this.format(this.getHiTime())).append(this.sep).append(this.format(this.getLoTime())).append(this.sep).append(this.format(this.getCount())).toString();
    }

    public static String getUUIDHex() {
        UUIDHexGenerator uuid = new UUIDHexGenerator();
        return uuid.generate();
    }

    public static void main(String[] str) {
        for (int i = 0; i <= 100; ++i) {
            System.out.println(UUIDHexGenerator.getUUIDHex());
        }
    }

    static {
        int ipadd;
        counter = 0;
        JVM = (int)(System.currentTimeMillis() >>> 8);
        try {
            ipadd = UUIDHexGenerator.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            ipadd = 0;
        }
        IP = ipadd;
    }
}

