/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.xsqlbuilder.datamodifier;

import com.kotelmems.platform.xsqlbuilder.datamodifier.DataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.DataModifierException;
import com.kotelmems.platform.xsqlbuilder.datamodifier.DataModifierSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DataModifierBean {
    private static final String DATA_MODIFIER_OPERATOR = "?";
    private Map modifiers = new HashMap();

    public void registerDataModifier(String modifierName, DataModifier modifier) {
        this.modifiers.put(modifierName, modifier);
    }

    public void deregisterDataModifier(String modifierName) {
        this.modifiers.remove(modifierName);
    }

    public Map getAvailableDataModifiers() {
        return Collections.unmodifiableMap(this.modifiers);
    }

    public static String getModifyVariable(String completeExpression) {
        int index = completeExpression.indexOf(DATA_MODIFIER_OPERATOR);
        if (index == -1) {
            return completeExpression;
        }
        return completeExpression.substring(0, index);
    }

    public Object modify(String completeExpression, Object dataModifyValue) {
        int index = completeExpression.indexOf(DATA_MODIFIER_OPERATOR);
        if (index == -1) {
            return dataModifyValue;
        }
        String dataModifierExpression = completeExpression.substring(index);
        try {
            return this.directModify0(dataModifierExpression, dataModifyValue);
        }
        catch (DataModifierException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataModifierException("cannot modify value:" + dataModifyValue + " with completeExpression:" + completeExpression, e);
        }
    }

    public Object directModify(String dataModifierExpression, Object dataModifyValue) {
        try {
            return this.directModify0(dataModifierExpression, dataModifyValue);
        }
        catch (DataModifierException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataModifierException("cannot modify value:" + dataModifyValue + " with expression:" + dataModifierExpression, e);
        }
    }

    private Object directModify0(String dataModifierExpression, Object dataModifyValue) throws DataModifierException, Exception {
        if (DataModifierBean.isEmptyString(dataModifierExpression)) {
            return dataModifyValue;
        }
        if (!dataModifierExpression.startsWith(DATA_MODIFIER_OPERATOR)) {
            throw new DataModifierSyntaxException("Syntax error,DataModifier expression must start with [?]. auctal:" + dataModifierExpression);
        }
        StringTokenizer tokenizer = new StringTokenizer(dataModifierExpression, DATA_MODIFIER_OPERATOR);
        Object result = dataModifyValue;
        while (tokenizer.hasMoreElements()) {
            DataModifier dataModifier;
            String singleExpression;
            String modifierName = singleExpression = (String)tokenizer.nextElement();
            String modifierArgument = null;
            int index = -1;
            index = singleExpression.indexOf("(");
            if (index != -1) {
                if (!singleExpression.endsWith(")")) {
                    throw new DataModifierSyntaxException("Syntax error,modifierArguments must wrap with '(arg1,arg2)'");
                }
                modifierName = modifierName.substring(0, index);
                modifierArgument = singleExpression.substring(index + 1, singleExpression.length() - 1);
            }
            if ((dataModifier = (DataModifier)this.modifiers.get(modifierName)) == null) {
                throw new DataModifierSyntaxException("not found DataModifier with give name[" + modifierName + "],available modifier names:" + this.modifiers.keySet());
            }
            result = dataModifier.modify(result, modifierArgument);
        }
        return result;
    }

    private static boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }
}

