/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.redisson;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    @Value(value="${redis.host}")
    private String host;
    @Value(value="${redis.port}")
    private String port;
    @Value(value="${redis.database:10}")
    private int database;
    @Value(value="${redis.pass}")
    private String password;
    @Value(value="${redis.maxWait:3000}")
    private int timeout;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        SingleServerConfig serverConfig = config.useSingleServer();
        serverConfig.setAddress(String.format("redis://%s:%s", this.host, this.port));
        serverConfig.setDatabase(this.database);
        serverConfig.setPassword(this.password);
        serverConfig.setTimeout(this.timeout);
        return Redisson.create((Config)config);
    }
}

