/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.redisson;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonDelayQueue {
    private static final Logger log = LoggerFactory.getLogger(RedissonDelayQueue.class);
    @Resource
    private RedissonClient redissonClient;
    private RDelayedQueue<String> delayQueue;
    private RBlockingQueue<String> blockingQueue;
    private String name = "Jumi_DelayQueue";

    public void init(String name) {
        this.name = name;
        this.initDelayQueue();
        this.startDelayQueueConsumer();
    }

    private void initDelayQueue() {
        this.blockingQueue = this.redissonClient.getBlockingQueue("Jumi_DelayQueue");
        this.delayQueue = this.redissonClient.getDelayedQueue(this.blockingQueue);
    }

    private void startDelayQueueConsumer() {
        new Thread(() -> {
            log.info(">>>>>>>>>>>>>>>>Thread");
            while (true) {
                log.info(">>>>>>>>>>>>>>>>");
                try {
                    String task = (String)this.blockingQueue.take();
                    log.info("\u63a5\u6536\u5230\u5ef6\u8fdf\u4efb\u52a1:{}", (Object)task);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, this.name + "-Consumer").start();
    }

    public void offerTask(String task, long seconds) {
        log.info("\u6dfb\u52a0\u5ef6\u8fdf\u4efb\u52a1:{} \u5ef6\u8fdf\u65f6\u95f4:{}s", (Object)task, (Object)seconds);
        this.delayQueue.offer((Object)task, seconds, TimeUnit.SECONDS);
    }
}

