/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import com.jumipm.utils.MultiFormatWatermarkUtil;
import com.spire.doc.Document;
import com.spire.doc.FileFormat;
import com.spire.doc.HeaderFooter;
import com.spire.doc.Section;
import com.spire.doc.TextWatermark;
import com.spire.doc.WatermarkBase;
import com.spire.doc.documents.Paragraph;
import com.spire.doc.documents.ShapeLineStyle;
import com.spire.doc.documents.ShapeType;
import com.spire.doc.documents.WatermarkLayout;
import com.spire.doc.fields.ShapeObject;
import com.spire.doc.interfaces.IDocument;
import com.spire.doc.interfaces.IDocumentObject;
import com.spire.pdf.PdfDocument;
import com.spire.pdf.PdfPageBase;
import com.spire.pdf.annotations.PdfAnnotationCollection;
import com.spire.pdf.annotations.PdfWatermarkAnnotationWidget;
import com.spire.pdf.graphics.PdfBrush;
import com.spire.pdf.graphics.PdfBrushes;
import com.spire.pdf.graphics.PdfFontBase;
import com.spire.pdf.graphics.PdfTilingBrush;
import com.spire.pdf.graphics.PdfTrueTypeFont;
import com.spire.presentation.IAutoShape;
import com.spire.presentation.IShape;
import com.spire.presentation.PortionEx;
import com.spire.presentation.Presentation;
import com.spire.presentation.drawing.FillFormatType;
import com.spire.xls.ExcelVersion;
import com.spire.xls.Workbook;
import com.spire.xls.Worksheet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpireOfficeWatermarkOptUtils {
    private static final Logger log = LoggerFactory.getLogger(SpireOfficeWatermarkOptUtils.class);
    public static final String WORD = "docx";
    public static final String PDF = "pdf";
    public static final String EXCEL = "xlsx";
    public static final String PPT = "pptx";
    public static final String Other = "other";
    public static final String IMAGES = "jpg,jpeg,gif,png,bmp";
    public static final String IMAGE = "image";
    public static final String WATERMARKFOLDER = "watermarkfile";

    public static String addTextWatermark(String rootFolder, String attachUrl, String watermark, String watermarkId) {
        log.info("\u6dfb\u52a0\u6c34\u5370\u5f00\u59cb watermarkId:{}, watermark:{}", (Object)watermarkId, (Object)watermark);
        String sourceFile = rootFolder.concat(File.separator) + attachUrl;
        String fileType = SpireOfficeWatermarkOptUtils.getFileTypeByFileName(attachUrl);
        log.info("\u6c34\u5370\u7c7b\u578b  fileType:{}", (Object)fileType);
        String targetFile = SpireOfficeWatermarkOptUtils.getWatermarkFilePath(rootFolder, attachUrl, watermarkId);
        File watermarkFile = new File(targetFile);
        if (watermarkFile.exists()) {
            return targetFile;
        }
        log.info("addTextWatermark start>>>>>>");
        if (WORD.equals(fileType)) {
            SpireOfficeWatermarkOptUtils.addTextWatermarkFormWord(targetFile, sourceFile, watermark, 5, 3);
        } else if (PDF.equals(fileType)) {
            SpireOfficeWatermarkOptUtils.addTextWatermarkFormPDF(targetFile, sourceFile, watermark, 5, 3);
        } else if (EXCEL.equals(fileType)) {
            SpireOfficeWatermarkOptUtils.addWatermarkFromExcel(targetFile, sourceFile, watermark);
        } else {
            if (PPT.equals(fileType)) {
                try {
                    SpireOfficeWatermarkOptUtils.addWatermarkFromPPT(targetFile, sourceFile, watermark, 5, 3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return sourceFile;
                }
            }
            if (IMAGE.equals(fileType)) {
                try {
                    MultiFormatWatermarkUtil.addTextWatermark(sourceFile, targetFile, watermark, new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 30), Color.RED, MultiFormatWatermarkUtil.WatermarkPosition.BOTTOM_RIGHT);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return sourceFile;
                }
            }
        }
        log.info("addTextWatermark end>>>>>>");
        return targetFile;
    }

    private static String getFileTypeByFileName(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (WORD.equals(suffix) || "doc".equals(suffix)) {
            return WORD;
        }
        if (EXCEL.equals(suffix) || "xls".equals(suffix)) {
            return EXCEL;
        }
        if (PPT.equals(suffix) || "ppt".equals(suffix)) {
            return PPT;
        }
        if (PDF.equals(suffix)) {
            return PDF;
        }
        if (IMAGES.indexOf(suffix) != -1) {
            return IMAGE;
        }
        return Other;
    }

    private static void addTextWatermarkFormPDF(String targetFile, String sourceFile, String watermark, int row, int column) {
        PdfDocument pdf = new PdfDocument();
        pdf.loadFromFile(sourceFile);
        PdfTrueTypeFont font = new PdfTrueTypeFont(new Font("\u9ed1\u4f53", 1, 20));
        for (int i = 0; i < pdf.getPages().getCount(); ++i) {
            PdfPageBase pageBase = pdf.getPages().get(i);
            float set1 = (float)(font.measureString(watermark).getWidth() * Math.sqrt(2.0) / 4.0);
            float set2 = (float)(font.measureString(watermark).getHeight() * Math.sqrt(2.0) / 4.0);
            PdfTilingBrush brush = new PdfTilingBrush((Dimension2D)new Dimension((int)(pageBase.getActualSize().getWidth() / (double)column), (int)(pageBase.getActualSize().getHeight() / (double)row)));
            brush.getGraphics().setTransparency(0.3f);
            brush.getGraphics().save();
            brush.getGraphics().translateTransform(brush.getSize().getWidth() / 2.0 - (double)set1 - (double)set2, brush.getSize().getHeight() / 2.0 + (double)set1 - (double)set2);
            brush.getGraphics().rotateTransform(-45.0f);
            brush.getGraphics().drawString(watermark, (PdfFontBase)font, PdfBrushes.getViolet(), 0.0f, 0.0f);
            brush.getGraphics().restore();
            pageBase.getCanvas().drawRectangle((PdfBrush)brush, (Rectangle2D)new Rectangle(new Point(0, 0), new Dimension((int)pageBase.getActualSize().getWidth(), (int)pageBase.getActualSize().getHeight())));
        }
        pdf.saveToFile(targetFile);
        pdf.dispose();
    }

    private static void addTextWatermarkFormPDF(String targetFile, String sourceFile, String watermark) {
        PdfDocument pdf = new PdfDocument();
        pdf.loadFromFile(sourceFile);
        PdfTrueTypeFont font = new PdfTrueTypeFont(new Font("\u9ed1\u4f53", 1, 50));
        float set1 = (float)(font.measureString(watermark).getWidth() * Math.sqrt(2.0) / 4.0);
        float set2 = (float)(font.measureString(watermark).getHeight() * Math.sqrt(2.0) / 4.0);
        for (int i = 0; i < pdf.getPages().getCount(); ++i) {
            PdfPageBase page = pdf.getPages().get(i);
            page.getCanvas().setTransparency(0.8f);
            page.getCanvas().translateTransform(page.getCanvas().getSize().getWidth() / 2.0 - (double)set1 - (double)set2, page.getCanvas().getSize().getHeight() / 2.0 + (double)set1 - (double)set2);
            page.getCanvas().rotateTransform(-45.0f);
            page.getCanvas().drawString(watermark, (PdfFontBase)font, PdfBrushes.getDarkGray(), 0.0f, 0.0f);
        }
        pdf.saveToFile(targetFile);
        pdf.dispose();
    }

    private static void addTextWatermarkFormWord(String targetFile, String sourceFile, String watermark, int row, int column) {
        Document doc = new Document();
        doc.loadFromFile(sourceFile);
        ShapeObject shape = new ShapeObject((IDocument)doc, ShapeType.Text_Plain_Text);
        shape.setWidth(60.0f);
        shape.setHeight(20.0f);
        shape.setVerticalPosition(30.0f);
        shape.setHorizontalPosition(20.0f);
        shape.setRotation(315.0);
        shape.getWordArt().setText(watermark);
        shape.setFillColor(Color.LIGHT_GRAY);
        shape.setLineStyle(ShapeLineStyle.Single);
        shape.setStrokeColor(new Color(192, 192, 192, 255));
        shape.setStrokeWeight(1.0);
        for (int n = 0; n < doc.getSections().getCount(); ++n) {
            Section section = doc.getSections().get(n);
            HeaderFooter header = section.getHeadersFooters().getHeader();
            for (int i = 0; i < row; ++i) {
                Paragraph paragraph1 = header.addParagraph();
                for (int j = 0; j < column; ++j) {
                    shape = (ShapeObject)shape.deepClone();
                    shape.setVerticalPosition(50.0f + 150.0f * (float)i);
                    shape.setHorizontalPosition(20.0f + 160.0f * (float)j);
                    paragraph1.getChildObjects().add((IDocumentObject)shape);
                }
            }
        }
        doc.saveToFile(targetFile, FileFormat.Docx_2013);
        doc.dispose();
    }

    public static void addTextWatermarkFormWord(String targetFile, String sourceFile, String watermark) {
        Document doc = new Document();
        doc.loadFromFile(sourceFile);
        for (int n = 0; n < doc.getSections().getCount(); ++n) {
            Section section = doc.getSections().get(n);
            TextWatermark txtWatermark = new TextWatermark();
            txtWatermark.setText(watermark);
            txtWatermark.setFontSize(40.0f);
            txtWatermark.setColor(Color.red);
            txtWatermark.setLayout(WatermarkLayout.Diagonal);
            section.getDocument().setWatermark((WatermarkBase)txtWatermark);
        }
        doc.saveToFile(targetFile, FileFormat.Docx);
        doc.dispose();
    }

    private static void addWatermarkFromExcel(String targetFile, String sourceFile, String watermark) {
        Workbook workbook = new Workbook();
        workbook.loadFromFile(sourceFile);
        Font font = new Font("\u4eff\u5b8b", 0, 40);
        for (Worksheet sheet : workbook.getWorksheets()) {
            BufferedImage imgWtrmrk = SpireOfficeWatermarkOptUtils.drawText(watermark, font, Color.pink, Color.white, sheet.getPageSetup().getPageHeight(), sheet.getPageSetup().getPageWidth());
            sheet.getPageSetup().setLeftHeaderImage(imgWtrmrk);
            sheet.getPageSetup().setLeftHeader("&G");
        }
        workbook.saveToFile(targetFile, ExcelVersion.Version2010);
        workbook.dispose();
    }

    private static BufferedImage drawText(String text, Font font, Color textColor, Color backColor, double height, double width) {
        BufferedImage img = new BufferedImage((int)width, (int)height, 2);
        Graphics2D loGraphic = img.createGraphics();
        FontMetrics loFontMetrics = loGraphic.getFontMetrics(font);
        int liStrWidth = loFontMetrics.stringWidth(text);
        int liStrHeight = loFontMetrics.getHeight();
        loGraphic.setColor(backColor);
        loGraphic.fillRect(0, 0, (int)width, (int)height);
        loGraphic.translate(((int)width - liStrWidth) / 2, ((int)height - liStrHeight) / 2);
        loGraphic.rotate(Math.toRadians(-45.0));
        loGraphic.translate(-((int)width - liStrWidth) / 2, -((int)height - liStrHeight) / 2);
        loGraphic.setFont(font);
        loGraphic.setColor(textColor);
        loGraphic.drawString(text, ((int)width - liStrWidth) / 2, ((int)height - liStrHeight) / 2);
        loGraphic.dispose();
        return img;
    }

    private static String getWatermarkFilePath(String rootfolder, String attachUrl, String watermarkId) {
        File sourceFile = new File(rootfolder.concat(File.separator).concat(attachUrl));
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String fileName = attachUrl.substring(attachUrl.lastIndexOf("/") + 1);
        String watermarkFilePath = rootfolder.concat("/").concat(WATERMARKFOLDER).concat("/").concat(watermarkId).concat("/").concat(fileName);
        String filePath1 = watermarkFilePath.substring(0, watermarkFilePath.lastIndexOf("/"));
        File directory = new File(filePath1);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return watermarkFilePath;
    }

    public static void addWatermarkFromPPT(String targetFile, String sourceFile, String watermark, int row, int column) throws Exception {
        Presentation presentation = new Presentation();
        presentation.loadFromFile(sourceFile);
        int width = 300;
        int height = 200;
        float x = 30.0f;
        float y = 80.0f;
        int page = presentation.getSlides().getCount();
        for (int n = 0; n < page; ++n) {
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < column; ++j) {
                    Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
                    IAutoShape shape = presentation.getSlides().get(n).getShapes().appendShape(com.spire.presentation.ShapeType.RECTANGLE, (Rectangle2D)rect);
                    shape.getFill().setFillType(FillFormatType.NONE);
                    shape.getShapeStyle().getLineColor().setColor(Color.white);
                    shape.setRotation(-45.0f);
                    shape.getLocking().setSelectionProtection(true);
                    shape.getLine().setFillType(FillFormatType.NONE);
                    shape.getTextFrame().setText(watermark);
                    PortionEx textRange = shape.getTextFrame().getTextRange();
                    textRange.getFill().setFillType(FillFormatType.SOLID);
                    textRange.getFill().getSolidColor().setColor(Color.pink);
                    textRange.setFontHeight(20.0f);
                    x = (float)((double)x + (100.0 + presentation.getSlideSize().getSize().getWidth() / 5.0));
                }
                x = 30.0f;
                y = (float)((double)y + (100.0 + presentation.getSlideSize().getSize().getHeight() / 6.0));
            }
        }
        presentation.saveToFile(targetFile, com.spire.presentation.FileFormat.PPTX_2010);
    }

    public static void addWatermarkFromPPT(String targetFile, String sourceFile, String watermark) throws Exception {
        Presentation presentation = new Presentation();
        presentation.loadFromFile(sourceFile);
        int width = 400;
        int height = 300;
        Rectangle2D.Double rect = new Rectangle2D.Double((presentation.getSlideSize().getSize().getWidth() - (double)width) / 2.0, (presentation.getSlideSize().getSize().getHeight() - (double)height) / 2.0, width, height);
        int page = presentation.getSlides().getCount();
        for (int i = 0; i < page; ++i) {
            IAutoShape shape = presentation.getSlides().get(i).getShapes().appendShape(com.spire.presentation.ShapeType.RECTANGLE, (Rectangle2D)rect);
            shape.getFill().setFillType(FillFormatType.NONE);
            shape.getShapeStyle().getLineColor().setColor(Color.white);
            shape.setRotation(-45.0f);
            shape.getLocking().setSelectionProtection(true);
            shape.getLine().setFillType(FillFormatType.NONE);
            shape.getTextFrame().setText(watermark);
            PortionEx textRange = shape.getTextFrame().getTextRange();
            textRange.getFill().setFillType(FillFormatType.SOLID);
            textRange.getFill().getSolidColor().setColor(Color.pink);
            textRange.setFontHeight(50.0f);
        }
        presentation.saveToFile(targetFile, com.spire.presentation.FileFormat.PPTX_2010);
        presentation.dispose();
    }

    public static String removeWatermark(String rootFolder, String attachUrl, String watermark, String watermarkId) {
        String sourceFile = rootFolder.concat(File.separator) + attachUrl;
        String fileType = SpireOfficeWatermarkOptUtils.getFileTypeByFileName(attachUrl);
        log.info("\u6c34\u5370\u7c7b\u578b  fileType:{}", (Object)fileType);
        String targetFile = SpireOfficeWatermarkOptUtils.getWatermarkFilePath(rootFolder, attachUrl, watermarkId);
        File watermarkFile = new File(targetFile);
        if (watermarkFile.exists()) {
            return targetFile;
        }
        if (WORD.equals(fileType)) {
            SpireOfficeWatermarkOptUtils.removeWatermarkFormWord(targetFile, sourceFile);
        } else if (PDF.equals(fileType)) {
            SpireOfficeWatermarkOptUtils.removeWatermarkFromPDF(targetFile, sourceFile, watermark);
        } else if (EXCEL.equals(fileType)) {
            try {
                SpireOfficeWatermarkOptUtils.removeWatermarkFromPPT(targetFile, sourceFile, watermark);
            }
            catch (Exception e) {
                e.printStackTrace();
                return sourceFile;
            }
        } else if (PPT.equals(fileType)) {
            return sourceFile;
        }
        return targetFile;
    }

    private static void removeWatermarkFromPDF(String rootfolder, String attachUrl, String watermark) {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.loadFromFile(rootfolder.concat(File.separator).concat(attachUrl));
        for (int i = 0; i < pdfDocument.getPages().getCount(); ++i) {
            PdfAnnotationCollection annotationWidget = pdfDocument.getPages().get(i).getAnnotationsWidget();
            for (int j = 0; j < annotationWidget.getCount(); ++j) {
                if (!(annotationWidget.get(j) instanceof PdfWatermarkAnnotationWidget) || !annotationWidget.get(j).getText().equals(watermark)) continue;
                annotationWidget.remove(annotationWidget.get(j));
            }
        }
        String watermarkFilePath = rootfolder.concat(File.separator).concat(WATERMARKFOLDER).concat(File.separator).concat(attachUrl);
        pdfDocument.saveToFile(watermarkFilePath);
        pdfDocument.dispose();
    }

    private static void removeWatermarkFormWord(String rootfolder, String attachUrl) {
        Document document = new Document();
        document.loadFromFile(rootfolder.concat(File.separator) + attachUrl);
        document.setWatermark(null);
        String watermarkFilePath = rootfolder.concat(File.separator).concat(WATERMARKFOLDER).concat(File.separator).concat(attachUrl);
        document.saveToFile(watermarkFilePath, FileFormat.Docx_2013);
        document.dispose();
    }

    public static void removeWatermarkFromPPT(String targetFile, String sourceFile, String watermark) throws Exception {
        int i;
        Presentation presentation = new Presentation();
        presentation.loadFromFile(sourceFile);
        for (i = 0; i < presentation.getSlides().getCount(); ++i) {
            for (int j = 0; j < presentation.getSlides().get(i).getShapes().getCount(); ++j) {
                IAutoShape shape;
                if (!(presentation.getSlides().get(i).getShapes().get(j) instanceof IAutoShape) || !(shape = (IAutoShape)presentation.getSlides().get(i).getShapes().get(j)).getTextFrame().getText().contains(watermark)) continue;
                presentation.getSlides().get(i).getShapes().remove((IShape)shape);
            }
        }
        for (i = 0; i < presentation.getSlides().getCount(); ++i) {
            presentation.getSlides().get(i).getSlideBackground().getFill().setFillType(FillFormatType.NONE);
        }
        presentation.saveToFile(targetFile, com.spire.presentation.FileFormat.PPTX_2013);
    }
}

