/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.redisson;

import com.jumipm.common.redisson.DelayQueueConsumer;
import com.jumipm.common.redisson.RedissonDelayQueue;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    private static final Logger log = LoggerFactory.getLogger(RedissonConfig.class);
    @Value(value="${redis.host:127.0.0.1}")
    private String host;
    @Value(value="${redis.port:6379}")
    private String port;
    @Value(value="${redis.database:10}")
    private int database;
    @Value(value="${redis.pass:}")
    private String password;
    @Value(value="${redis.maxWait:3000}")
    private int timeout;
    @Value(value="${redis.redisson.minimumIdleSize:1}")
    private int minimumIdleSize;
    @Value(value="${redis.redisson.poolSize:10}")
    private int poolSize;
    @Value(value="${redis.redisson.retryInterval:1500}")
    private int retryInterval;
    @Value(value="${redis.redisson.nettyThreads:4}")
    private int nettyThreads;
    @Value(value="${redis.redisson.messageMode:normal}")
    private String messageMode;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        SingleServerConfig serverConfig = config.useSingleServer();
        serverConfig.setAddress(String.format("redis://%s:%s", this.host, this.port));
        serverConfig.setDatabase(this.database);
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            serverConfig.setPassword(this.password);
        }
        config.setNettyThreads(this.nettyThreads);
        serverConfig.setTimeout(this.timeout);
        serverConfig.setConnectionPoolSize(this.poolSize);
        serverConfig.setConnectionMinimumIdleSize(this.minimumIdleSize);
        serverConfig.setRetryInterval(this.retryInterval);
        return Redisson.create((Config)config);
    }

    @Bean
    public RedissonDelayQueue redissonDelayQueue(List<DelayQueueConsumer> consumerList, RedissonClient redissonClient) {
        RedissonDelayQueue redissonDelayQueue = new RedissonDelayQueue(consumerList, redissonClient);
        log.info("messageMode is: {}", (Object)this.messageMode);
        if ("send".equals(this.messageMode)) {
            redissonDelayQueue.initOnlySend("common");
        } else {
            redissonDelayQueue.init("common");
        }
        return redissonDelayQueue;
    }
}

