/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.mybatis;

import com.baomidou.mybatisplus.autoconfigure.SpringBootVFS;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.ibatis.io.VFS;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(value={"com.jumipm.**.mapper"})
public class MybatisConfig {
    @Bean
    public MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean(DataSource dataSource) {
        VFS.addImplClass(SpringBootVFS.class);
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        mybatisSqlSessionFactoryBean.setDataSource(dataSource);
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/**/*Mapper.xml");
            mybatisSqlSessionFactoryBean.setMapperLocations(resources);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mybatisSqlSessionFactoryBean;
    }
}

