/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.crypto.impl;

import com.jumipm.common.crypto.JumiCrypto;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm4Crypto
implements JumiCrypto {
    private static final Logger log = LoggerFactory.getLogger(Sm4Crypto.class);
    private static final String ALGORITHM = "SM4";
    private static final String TRANSFORMATION = "SM4/ECB/PKCS5Padding";

    @Override
    public String encrypt(String plainText, String key) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] cipherText = new byte[]{};
        try {
            byte[] keyBytes = Hex.decode((String)key);
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, ALGORITHM);
            byte[] data = plainText.getBytes(StandardCharsets.UTF_8);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION, "BC");
            cipher.init(1, secretKeySpec);
            cipherText = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Hex.toHexString((byte[])cipherText);
    }

    @Override
    public String decrypt(String encryptedText, String key) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] decryptedBytes = new byte[]{};
        try {
            byte[] keyBytes = Hex.decode((String)key);
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, ALGORITHM);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION, "BC");
            cipher.init(2, secretKeySpec);
            decryptedBytes = cipher.doFinal(Hex.decode((String)encryptedText));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }
}

