/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.api3.common.filter;

import com.jumipm.common.redis.BaseRedisTemplate;
import com.jumipm.utils.ApiConstant;
import com.jumipm.utils.CacheParm;
import com.jumipm.utils.StrUtil;
import com.jumipm.utils.SysApiV3Info;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Api3Filter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(Api3Filter.class);
    private BaseRedisTemplate<CacheParm<SysApiV3Info>> baseRedisTemplate;
    private Set<String> excludes;

    public void init(FilterConfig filterConfig) throws ServletException {
        String initParameter = filterConfig.getInitParameter("excludes");
        this.excludes = new HashSet<String>();
        String[] split = initParameter.split(",");
        for (int i = 0; i < split.length; ++i) {
            this.excludes.add("/apiV3" + split[i]);
        }
        log.info("Api3Filter init >>>>>>>>>>> excludes is {}", this.excludes);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String urlReqPath = httpReq.getServletPath();
        if (this.excludes.contains(urlReqPath)) {
            log.info("\u5254\u9664\u9879\u4e0d\u62e6\u622a\uff01 urlReqPath is {}", (Object)urlReqPath);
        } else {
            String authorization = httpReq.getHeader("Authorization");
            log.info("authorization is null ? {}", (Object)StrUtil.isNull((String)authorization));
            if (StringUtils.isEmpty((CharSequence)authorization)) {
                log.info("\u975e\u6cd5\u8bf7\u6c42");
                httpReq.getRequestDispatcher("/apiV3/error/noauther").forward(servletRequest, servletResponse);
                return;
            }
            CacheParm cacheParm = (CacheParm)this.baseRedisTemplate.get("API_V3:" + authorization);
            if (cacheParm == null) {
                log.info("token is not exists or expired");
                httpReq.getRequestDispatcher("/apiV3/error/expire").forward(servletRequest, servletResponse);
                return;
            }
            this.baseRedisTemplate.expire("API_V3:" + authorization, ApiConstant.API_V3_AUTHOR_TIMEOUT.longValue());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    public void setBaseRedisTemplate(BaseRedisTemplate<CacheParm<SysApiV3Info>> baseRedisTemplate) {
        this.baseRedisTemplate = baseRedisTemplate;
    }
}

